/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.json;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.basyx.aas.factory.json.JSONToMetamodelConverter;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.submodel.metamodel.api.ISubModel;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IIdentifiable;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.SubModel;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONAASBundleFactory {
    private static Logger logger = LoggerFactory.getLogger(JSONAASBundleFactory.class);
    private String content;

    public JSONAASBundleFactory(String jsonContent) {
        this.content = jsonContent;
    }

    public JSONAASBundleFactory(Path jsonFile) throws IOException {
        this.content = new String(Files.readAllBytes(jsonFile));
    }

    public Set<AASBundle> create() {
        JSONToMetamodelConverter converter = new JSONToMetamodelConverter(this.content);
        List shells = converter.parseAAS();
        List submodels = converter.parseSubmodels();
        List assets = converter.parseAssets();
        HashSet<AASBundle> bundles = new HashSet<AASBundle>();
        for (AssetAdministrationShell shell : shells) {
            try {
                IReference assetRef = shell.getAssetReference();
                Asset asset = (Asset)this.getByReference(assetRef, assets);
                shell.setAsset(asset);
            }
            catch (ResourceNotFoundException e) {
                logger.warn("Can't find asset with id " + ((IKey)shell.getAssetReference().getKeys().get(0)).getValue() + " for AAS " + shell.getIdShort() + "; If the asset is not provided in another way, this is an error!");
            }
            Set<ISubModel> currentSM = this.retrieveSubmodelsForAAS(submodels, shell);
            bundles.add(new AASBundle((IAssetAdministrationShell)shell, currentSM));
        }
        return bundles;
    }

    private Set<ISubModel> retrieveSubmodelsForAAS(List<SubModel> submodels, AssetAdministrationShell shell) {
        HashSet<ISubModel> currentSM = new HashSet<ISubModel>();
        for (IReference submodelRef : shell.getSubmodelReferences()) {
            try {
                ISubModel sm = (ISubModel)this.getByReference(submodelRef, submodels);
                currentSM.add(sm);
                logger.debug("Found Submodel " + sm.getIdShort() + " for AAS " + shell.getIdShort());
            }
            catch (ResourceNotFoundException e) {
                logger.warn("Could not find Submodel " + ((IKey)submodelRef.getKeys().get(0)).getValue() + " for AAS " + shell.getIdShort() + "; If it is not hosted elsewhere this is an error!");
            }
        }
        return currentSM;
    }

    private <T extends IIdentifiable> T getByReference(IReference ref, List<T> identifiable) throws ResourceNotFoundException {
        IKey lastKey = null;
        Iterator iterator = ref.getKeys().iterator();
        while (iterator.hasNext()) {
            IKey key;
            lastKey = key = (IKey)iterator.next();
            Optional<IIdentifiable> match = identifiable.stream().filter(s -> s.getIdentification().getId().equals(key.getValue())).findFirst();
            if (!match.isPresent()) continue;
            return (T)match.get();
        }
        if (lastKey == null) {
            throw new ResourceNotFoundException("Could not resolve reference without keys");
        }
        throw new ResourceNotFoundException("Could not resolve reference with last key '" + lastKey.getValue() + "'");
    }
}

