/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.netcomm;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.basyx.components.netcomm.NetworkReceiver;
import org.eclipse.basyx.vab.protocol.basyx.CoderTools;

public abstract class TCPCommunicator {
    protected SocketChannel communicationToClient = null;
    protected Collection<NetworkReceiver> messageListeners = new LinkedList<NetworkReceiver>();

    public static String toString(byte[] value) {
        String str = null;
        try {
            str = new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return str;
    }

    public Selector addCommunicationSocket(Selector selector) {
        if (this.communicationToClient == null || !this.communicationToClient.isConnected()) {
            return selector;
        }
        if (this.communicationToClient.isBlocking()) {
            return selector;
        }
        try {
            this.communicationToClient.register(selector, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return selector;
    }

    public Selector getSelector() {
        try {
            return Selector.open();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendMessage(byte[] message) {
        ByteBuffer buffer = ByteBuffer.allocate(message.length + 4);
        byte[] frameSizeBytes = new byte[4];
        CoderTools.setInt32((byte[])frameSizeBytes, (int)0, (int)message.length);
        buffer.put(frameSizeBytes);
        buffer.put(message);
        buffer.flip();
        this.sendMessage(buffer);
    }

    public void sendMessage(String message) {
        ByteBuffer buffer = ByteBuffer.allocate(message.length() + 4);
        byte[] frameSizeBytes = new byte[4];
        CoderTools.setInt32((byte[])frameSizeBytes, (int)0, (int)message.length());
        buffer.put(frameSizeBytes);
        buffer.put(message.getBytes());
        buffer.flip();
        this.sendMessage(buffer);
    }

    public void sendMessage(ByteBuffer messageBuffer) {
        if (this.communicationToClient == null) {
            return;
        }
        try {
            this.communicationToClient.write(messageBuffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] readMessage() {
        try {
            ByteBuffer rxBuffer1 = ByteBuffer.allocate(4);
            this.readBytes(rxBuffer1, 4);
            int frameSize = CoderTools.getInt32((byte[])rxBuffer1.array(), (int)0);
            ByteBuffer rxBuffer2 = ByteBuffer.allocate(frameSize);
            this.readBytes(rxBuffer2, frameSize);
            byte[] rxFrame = rxBuffer2.array();
            return rxFrame;
        }
        catch (IOException e) {
            if (!this.communicationToClient.isConnected()) {
                return null;
            }
            e.printStackTrace();
            return null;
        }
    }

    public String readStringMessage() {
        byte[] msg = this.readMessage();
        if (msg == null) {
            return null;
        }
        return TCPCommunicator.toString(msg);
    }

    public void close() {
        try {
            this.communicationToClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void readBytes(ByteBuffer bytes, int expectedBytes) throws IOException {
        while (bytes.position() < expectedBytes) {
            this.communicationToClient.read(bytes);
        }
    }

    public void addTCPMessageListener(NetworkReceiver addedListener) {
        this.messageListeners.add(addedListener);
    }

    public void removeTCPMessageListener(NetworkReceiver addedListener) {
        this.messageListeners.remove(addedListener);
    }

    protected void notifyListeners(byte[] message) {
        for (NetworkReceiver listener : this.messageListeners) {
            listener.onReceive(message);
        }
    }
}

