/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.processengine.connector;

import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.eclipse.basyx.components.processengine.connector.IDeviceServiceExecutor;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceServiceDelegate
implements JavaDelegate {
    private static final Logger logger = LoggerFactory.getLogger(DeviceServiceDelegate.class);
    private Expression submodelId;
    private Expression serviceName;
    private Expression serviceProvider;
    private Expression serviceParameter;
    private static IDeviceServiceExecutor executor;
    private GSONTools gson = new GSONTools((GSONToolsFactory)new DefaultTypeFactory());

    public void execute(DelegateExecution execution) throws Exception {
        String servicename = (String)this.serviceName.getValue((VariableScope)execution);
        String id = (String)this.submodelId.getValue((VariableScope)execution);
        String params = (String)this.serviceParameter.getValue((VariableScope)execution);
        ArrayList<Object> paramarray = new ArrayList<Object>();
        paramarray.addAll((Collection)this.gson.deserialize(params));
        String processName = execution.getProcessBusinessKey();
        String deviceAASId = (String)this.serviceProvider.getValue((VariableScope)execution);
        logger.debug("#######process instance: " + processName + " current activity: " + execution.getCurrentActivityName() + " is executed by " + deviceAASId);
        try {
            executor.executeService(servicename, deviceAASId, id, paramarray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setDeviceServiceExecutor(IDeviceServiceExecutor ex) {
        executor = ex;
    }

    public static IDeviceServiceExecutor getExecutor() {
        return executor;
    }
}

