/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.processengine.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.aas.manager.api.IAssetAdministrationShellManager;
import org.eclipse.basyx.components.processengine.connector.IDeviceServiceExecutor;
import org.eclipse.basyx.submodel.metamodel.api.ISubModel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceServiceExecutor
implements IDeviceServiceExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DeviceServiceExecutor.class);
    protected IAssetAdministrationShellManager manager;
    protected String serviceName;
    protected String serviceProvider;
    protected String serviceSubmodelId;
    protected List<Object> parameters = new ArrayList<Object>();

    public DeviceServiceExecutor(IAssetAdministrationShellManager manager) {
        this.manager = manager;
    }

    @Override
    public Object executeService(String servicename, String serviceProvider, String submodelid, List<Object> params) {
        try {
            Identifier aasId = new Identifier(IdentifierType.CUSTOM, serviceProvider);
            Identifier smId = new Identifier(IdentifierType.CUSTOM, submodelid);
            ISubModel serviceSubmodel = this.manager.retrieveSubModel((IIdentifier)aasId, (IIdentifier)smId);
            Map operations = serviceSubmodel.getOperations();
            IOperation op = (IOperation)operations.get(servicename);
            logger.debug("#Service Executor#--Call service: %s with parameter: %s \n", (Object)servicename, params);
            Object position = op.invoke(params.toArray());
            return position;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public String getServiceSubmodelId() {
        return this.serviceSubmodelId;
    }
}

