/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.provider;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.haskind.ModelingKind;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelFacadeCustomSemantics;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelFacadeIRDISemantics;
import org.eclipse.basyx.submodel.metamodel.map.SubModel;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Constraint;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Qualifiable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Qualifier;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.restapi.SubModelProvider;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.vab.VABSubmodelAPI;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.map.VABMapProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConfiguredProvider
extends SubModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(BaseConfiguredProvider.class);
    protected SubModel submodelData = null;
    public static final String SUBMODELSEMANTICS = "submodelSemantics";
    public static final String TYPE = "type";
    public static final String SEMANTICSINTERNAL = "semanticsInternal";
    public static final String SUBMODELID = "submodelID";

    public BaseConfiguredProvider(Map<Object, Object> cfgValues) {
        this.submodelData = this.createSubModel(cfgValues);
        this.setSubmodel(this.submodelData);
    }

    protected void setSubmodel(SubModel sm) {
        this.setAPI((ISubmodelAPI)new VABSubmodelAPI((IModelProvider)new VABMapProvider((Map)sm)));
    }

    protected Collection<String> splitString(String input) {
        HashSet<String> result = new HashSet<String>();
        for (String inputStr : input.split(",")) {
            result.add(inputStr.trim());
        }
        return result;
    }

    protected Collection<String> getConfiguredProperties(Map<Object, Object> cfgValues) {
        return this.splitString((String)cfgValues.get("submodelElements"));
    }

    protected void printHashMap(Map map, int indent) {
        for (Object key : map.keySet()) {
            int i;
            if (map.get(key) instanceof Map) {
                for (i = 0; i < indent; ++i) {
                    logger.debug(" ");
                }
                logger.debug("  " + key);
                this.printHashMap((Map)map.get(key), indent + 2);
                continue;
            }
            for (i = 0; i < indent; ++i) {
                logger.debug(" ");
            }
            logger.debug("  " + key + " = " + map.get(key));
        }
    }

    protected String[] splitPath(String path) {
        return path.split("/");
    }

    protected SubModel createSubModel(Map<Object, Object> cfgValues) {
        SubModel submodel = null;
        String basyx_submodelSemantics = null;
        try {
            basyx_submodelSemantics = cfgValues.get(BaseConfiguredProvider.buildBasyxCfgName(SUBMODELSEMANTICS)).toString().toLowerCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String basyx_idType = null;
        try {
            basyx_idType = cfgValues.get(BaseConfiguredProvider.buildBasyxCfgName("idType")).toString().toLowerCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String basyx_id = null;
        try {
            basyx_id = cfgValues.get(BaseConfiguredProvider.buildBasyxCfgName("id")).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String basyx_idShort = null;
        try {
            basyx_idShort = cfgValues.get(BaseConfiguredProvider.buildBasyxCfgName("idShort")).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String basyx_category = null;
        try {
            basyx_category = cfgValues.get(BaseConfiguredProvider.buildBasyxCfgName("category")).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String basyx_description = null;
        try {
            basyx_description = cfgValues.get(BaseConfiguredProvider.buildBasyxCfgName("description")).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String basyx_qualifier = null;
        try {
            basyx_qualifier = cfgValues.get(BaseConfiguredProvider.buildBasyxCfgName("qualifier")).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String basyx_qualifierType = null;
        try {
            basyx_qualifierType = cfgValues.get(BaseConfiguredProvider.buildBasyxCfgName("qualifier", TYPE)).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String basyx_version = null;
        try {
            basyx_version = cfgValues.get(BaseConfiguredProvider.buildBasyxCfgName("version")).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String basyx_revision = null;
        try {
            basyx_revision = cfgValues.get(BaseConfiguredProvider.buildBasyxCfgName("revision")).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IdentifierType idType = IdentifierType.CUSTOM;
        if (basyx_idType == null) {
            basyx_idType = "IdentifierType.Custom";
        }
        if (basyx_idType.equals("IdentifierType.IRDI")) {
            idType = IdentifierType.IRDI;
        }
        if (basyx_idType.equals("IdentifierType.URI")) {
            idType = IdentifierType.IRI;
        }
        if (basyx_idType.equals("IdentifierType.Custom")) {
            idType = IdentifierType.CUSTOM;
        }
        if (basyx_submodelSemantics == null) {
            basyx_submodelSemantics = IdentifierType.CUSTOM.toString().toLowerCase();
        }
        if (basyx_submodelSemantics.equals(IdentifierType.IRDI.toString().toLowerCase())) {
            submodel = new SubmodelFacadeIRDISemantics(basyx_submodelSemantics, idType, basyx_id, basyx_idShort, basyx_category, new LangStrings("", basyx_description), (Constraint)new Qualifier(basyx_qualifierType, basyx_qualifier, "", null), null, ModelingKind.INSTANCE, basyx_version, basyx_revision);
        }
        if (basyx_submodelSemantics.equals(IdentifierType.CUSTOM.toString().toLowerCase())) {
            submodel = new SubmodelFacadeCustomSemantics(basyx_submodelSemantics, idType, basyx_id, basyx_idShort, basyx_category, new LangStrings("", basyx_description), (Constraint)new Qualifier(basyx_qualifierType, basyx_qualifier, "", null), new HasDataSpecification(), ModelingKind.INSTANCE, basyx_version, basyx_revision);
        }
        if (submodel == null) {
            submodel = new SubModel();
        }
        return submodel;
    }

    protected Property createSubmodelElement(String propertyName, Object propertyValue, Map<Object, Object> cfgValues) {
        String propertyType = cfgValues.get(BaseConfiguredProvider.buildCfgName(propertyName, TYPE)).toString();
        if (propertyType.equals("Property")) {
            return this.createProperty(propertyName, propertyValue, cfgValues);
        }
        return null;
    }

    protected Property createProperty(String propertyName, Object propertyValue, Map<Object, Object> cfgValues) {
        String property_semanticsInternal = null;
        try {
            property_semanticsInternal = cfgValues.get(BaseConfiguredProvider.buildCfgName(propertyName, SEMANTICSINTERNAL)).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String property_qualifier = null;
        try {
            property_qualifier = cfgValues.get(BaseConfiguredProvider.buildCfgName(propertyName, "qualifier")).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String property_qualifierType = null;
        try {
            property_qualifierType = cfgValues.get(BaseConfiguredProvider.buildCfgName(propertyName, "qualifier", TYPE)).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String property_description = null;
        try {
            property_description = cfgValues.get(BaseConfiguredProvider.buildCfgName(propertyName, "description")).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Property prop = new Property(propertyValue, new Referable(propertyName, "", new LangStrings("", property_description)), new Reference(new Key(KeyElements.PROPERTY, true, property_semanticsInternal, IdentifierType.CUSTOM)), new Qualifiable((Constraint)new Qualifier(property_qualifierType, property_qualifier, "", null)));
        return prop;
    }

    public static String buildBasyxCfgName(String ... valueName) {
        return BaseConfiguredProvider.buildCfgName("basyx", valueName);
    }

    public static String buildCfgName(String propertyName, String ... valueName) {
        String result = propertyName;
        for (String s : valueName) {
            result = result + "." + s;
        }
        return result;
    }
}

