/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.aas.manager.ConnectedAssetAdministrationShellManager;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.aas.registration.api.IAASRegistryService;
import org.eclipse.basyx.components.configuration.ConfigurableComponent;
import org.eclipse.basyx.components.configuration.builder.BaSyxServiceConfigurationBuilder;
import org.eclipse.basyx.vab.manager.VABConnectionManager;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.service.api.BaSyxService;

public abstract class BaseBaSyxService
implements BaSyxService,
ConfigurableComponent<BaSyxServiceConfigurationBuilder<?>> {
    protected boolean endExecution = false;
    protected String name = null;
    protected Map<String, ModelUrn> objectIDs = new HashMap<String, ModelUrn>();
    protected VABConnectionManager connectionManager = null;
    protected ConnectedAssetAdministrationShellManager connectedAASManager = null;
    protected IAASRegistryService registryProxy = null;

    @Override
    public BaSyxServiceConfigurationBuilder configure() {
        return new BaSyxServiceConfigurationBuilder(this);
    }

    @Override
    public void configureComponent(BaSyxServiceConfigurationBuilder<?> configuration) {
        this.setRegistry(configuration.getRegistry());
        this.setConnectionManager(configuration.getConnectionManager());
        this.setConnectedAASManager(configuration.getConnetedAASManager());
    }

    public boolean hasEnded() {
        return this.endExecution;
    }

    public void start() {
    }

    public void stop() {
        this.endExecution = true;
    }

    public BaSyxService setName(String newName) {
        this.name = newName;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void waitFor() {
    }

    protected boolean hasPrefix(String str, String prefix) {
        return str.startsWith(prefix);
    }

    protected String removePrefix(String str, String prefix) {
        try {
            return str.substring(prefix.length() + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    protected void addShortcut(String shortcut, ModelUrn urn) {
        this.objectIDs.put(shortcut, urn);
    }

    protected void removeShortcut(String shortcut) {
        this.objectIDs.remove(shortcut);
    }

    protected ModelUrn lookupURN(String shortcut) {
        return this.objectIDs.get(shortcut);
    }

    protected void clearShortcuts() {
        this.objectIDs.clear();
    }

    protected void setConnectionManager(VABConnectionManager connMngr) {
        this.connectionManager = connMngr;
    }

    public void setConnectedAASManager(ConnectedAssetAdministrationShellManager connectedAASManager) {
        this.connectedAASManager = connectedAASManager;
    }

    protected VABConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected VABElementProxy createVABConnection(String vabElementID) {
        return this.getConnectionManager().connectToVABElement(vabElementID);
    }

    protected void setRegistry(IAASRegistryService regProxy) {
        this.registryProxy = regProxy;
    }

    protected IAASRegistryService getRegistry() {
        return this.registryProxy;
    }
}

