/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.servlet.aas;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.MultiAASProvider;
import org.eclipse.basyx.aas.restapi.VABMultiSubmodelProvider;
import org.eclipse.basyx.submodel.metamodel.api.ISubModel;
import org.eclipse.basyx.submodel.metamodel.map.SubModel;
import org.eclipse.basyx.submodel.restapi.SubModelProvider;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.server.VABHTTPInterface;

public class AASBundleServlet
extends VABHTTPInterface<MultiAASProvider> {
    private static final long serialVersionUID = 4441135540490088430L;

    public AASBundleServlet(AASBundle bundle) {
        this(Collections.singleton(bundle));
    }

    public AASBundleServlet(Collection<AASBundle> bundles) {
        super((IModelProvider)new MultiAASProvider());
        MultiAASProvider multiAASProvider = (MultiAASProvider)this.getModelProvider();
        for (AASBundle bundle : bundles) {
            multiAASProvider.addMultiSubmodelProvider(bundle.getAAS().getIdShort(), this.createMultiSubmodelProvider(bundle));
        }
    }

    private VABMultiSubmodelProvider createMultiSubmodelProvider(AASBundle bundle) {
        VABMultiSubmodelProvider provider = new VABMultiSubmodelProvider();
        IAssetAdministrationShell shell = bundle.getAAS();
        if (!(shell instanceof AssetAdministrationShell)) {
            throw new RuntimeException("Only instances of AssetAdministrationShell are allowed here");
        }
        provider.setAssetAdministrationShell(new AASModelProvider((AssetAdministrationShell)shell));
        for (ISubModel sm : bundle.getSubmodels()) {
            if (!(sm instanceof SubModel)) {
                throw new RuntimeException("Only instances of SubModel are allowed here");
            }
            provider.addSubmodel(new SubModelProvider((SubModel)sm));
        }
        return provider;
    }
}

