/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.tools.propertyfile.opdef;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.basyx.components.tools.propertyfile.opdef.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationDefinition {
    private static Logger logger = LoggerFactory.getLogger(OperationDefinition.class);

    public static String getOperation(String opDef) {
        return opDef.substring(0, opDef.indexOf("("));
    }

    public static Collection<Parameter> getParameter(String opDef) {
        String[] callParameterList;
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        logger.debug("Parameters for: " + opDef);
        String callParameterStr = opDef.substring(opDef.indexOf("(") + 1, opDef.length() - 1).trim();
        for (String parameterDef : callParameterList = callParameterStr.split(",")) {
            logger.debug("[[" + parameterDef + "]]" + opDef);
            if (parameterDef.length() == 0) continue;
            result.add(new Parameter(parameterDef.substring(0, parameterDef.indexOf(":")).trim(), parameterDef.substring(parameterDef.indexOf(":") + 1).trim().toLowerCase()));
        }
        return result;
    }

    public static String getSQLString(String baseString, Collection<String> parameter) {
        String result = baseString;
        int counter = 1;
        for (String par : parameter) {
            result = result.replace("$" + counter, par);
            ++counter;
        }
        return result;
    }

    public static String getSQLString(String baseString, Map<String, Object> parameter) {
        String result = baseString;
        if (parameter != null) {
            for (String par : parameter.keySet()) {
                result = result.replace("$" + par, parameter.get(par).toString());
            }
        }
        return result;
    }
}

