/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.xml;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.basyx.aas.factory.xml.XMLToMetamodelConverter;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.submodel.metamodel.api.ISubModel;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IIdentifiable;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XMLAASBundleFactory {
    private static Logger logger = LoggerFactory.getLogger(XMLAASBundleFactory.class);
    private String content;

    public XMLAASBundleFactory(String xmlContent) {
        this.content = xmlContent;
    }

    public XMLAASBundleFactory(Path xmlFile) throws IOException {
        this.content = new String(Files.readAllBytes(xmlFile));
    }

    public Set<AASBundle> create() throws ParserConfigurationException, SAXException, IOException {
        XMLToMetamodelConverter converter = new XMLToMetamodelConverter(this.content);
        List shells = converter.parseAAS();
        List submodels = converter.parseSubmodels();
        List assets = converter.parseAssets();
        HashSet<AASBundle> bundles = new HashSet<AASBundle>();
        for (IAssetAdministrationShell shell : shells) {
            try {
                IReference assetRef = shell.getAssetReference();
                IAsset asset = (IAsset)this.getByReference(assetRef, assets);
                ((AssetAdministrationShell)shell).setAsset((Asset)asset);
            }
            catch (ResourceNotFoundException e) {
                logger.warn("Can't find asset with id " + ((IKey)shell.getAssetReference().getKeys().get(0)).getValue() + " for AAS " + shell.getIdShort() + "; If the asset is not provided in another way, this is an error!");
            }
            Set<ISubModel> currentSM = this.retrieveSubmodelsForAAS(submodels, shell);
            bundles.add(new AASBundle(shell, currentSM));
        }
        return bundles;
    }

    private Set<ISubModel> retrieveSubmodelsForAAS(List<ISubModel> submodels, IAssetAdministrationShell shell) {
        HashSet<ISubModel> currentSM = new HashSet<ISubModel>();
        for (IReference submodelRef : shell.getSubmodelReferences()) {
            try {
                ISubModel sm = this.getByReference(submodelRef, submodels);
                currentSM.add(sm);
                logger.debug("Found Submodel " + sm.getIdShort() + " for AAS " + shell.getIdShort());
            }
            catch (ResourceNotFoundException e) {
                logger.warn("Could not find Submodel " + ((IKey)submodelRef.getKeys().get(0)).getValue() + " for AAS " + shell.getIdShort() + "; If it is not hosted elsewhere this is an error!");
            }
        }
        return currentSM;
    }

    private <T extends IIdentifiable> T getByReference(IReference ref, List<T> submodels) throws ResourceNotFoundException {
        IKey lastKey = null;
        Iterator iterator = ref.getKeys().iterator();
        while (iterator.hasNext()) {
            IKey key;
            lastKey = key = (IKey)iterator.next();
            Optional<IIdentifiable> match = submodels.stream().filter(s -> s.getIdentification().getId().equals(key.getValue())).findFirst();
            if (!match.isPresent()) continue;
            return (T)match.get();
        }
        if (lastKey == null) {
            throw new ResourceNotFoundException("Could not resolve reference without keys");
        }
        throw new ResourceNotFoundException("Could not resolve reference with last key " + lastKey.getValue());
    }
}

