/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.support.bundle;

import java.util.Collection;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.registration.api.IAASRegistryService;
import org.eclipse.basyx.submodel.metamodel.api.ISubModel;
import org.eclipse.basyx.submodel.metamodel.map.SubModel;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.eclipse.basyx.support.bundle.AASBundleDescriptorFactory;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class AASBundleIntegrator {
    public static boolean integrate(IAASAggregator aggregator, Collection<AASBundle> bundles) {
        if (aggregator == null || bundles == null) {
            throw new RuntimeException("'aggregator' and 'bundles' must not be null.");
        }
        boolean objectUploaded = false;
        for (AASBundle bundle : bundles) {
            IAssetAdministrationShell aas = bundle.getAAS();
            try {
                aggregator.getAAS(aas.getIdentification());
            }
            catch (ResourceNotFoundException e) {
                if (aas instanceof AssetAdministrationShell) {
                    aggregator.createAAS((AssetAdministrationShell)aas);
                    objectUploaded = true;
                }
                throw new RuntimeException("aas Objects in bundles need to be instance of 'AssetAdministrationShell'");
            }
            IModelProvider provider = aggregator.getAASProvider(aas.getIdentification());
            for (ISubModel sm : bundle.getSubmodels()) {
                try {
                    provider.getModelPropertyValue("/aas/submodels/" + sm.getIdShort());
                }
                catch (ResourceNotFoundException e) {
                    if (sm instanceof SubModel) {
                        provider.setModelPropertyValue("/aas/submodels/" + sm.getIdShort(), (Object)sm);
                        objectUploaded = true;
                        continue;
                    }
                    throw new RuntimeException("sm Objects in bundles need to be instance of 'SubModel'");
                }
            }
        }
        return objectUploaded;
    }

    public static void register(IAASRegistryService registry, Collection<AASBundle> bundles, String aasAggregatorPath) {
        bundles.stream().map(b -> AASBundleDescriptorFactory.createAASDescriptor(b, aasAggregatorPath)).forEach(arg_0 -> ((IAASRegistryService)registry).register(arg_0));
    }
}

