/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.sql.query;

import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import org.eclipse.basyx.components.tools.propertyfile.opdef.OperationDefinition;
import org.eclipse.basyx.components.tools.propertyfile.opdef.Parameter;
import org.eclipse.basyx.components.tools.propertyfile.opdef.ResultFilter;
import org.eclipse.basyx.tools.sql.driver.ISQLDriver;
import org.eclipse.basyx.tools.sql.query.DynamicSQLRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSQLOperation
extends DynamicSQLRunner
implements Function<Object[], Object> {
    private static Logger logger = LoggerFactory.getLogger(DynamicSQLOperation.class);
    protected String sqlQueryString = null;
    protected String resultFilterString = null;

    public DynamicSQLOperation(ISQLDriver driver, String query, String sqlResultFilter) {
        super(driver);
        this.sqlQueryString = query;
        this.resultFilterString = sqlResultFilter;
    }

    public DynamicSQLOperation(String path, String user, String pass, String qryPfx, String qDrvCls, String query, String sqlResultFilter) {
        super(path, user, pass, qryPfx, qDrvCls);
        this.sqlQueryString = query;
        this.resultFilterString = sqlResultFilter;
    }

    @Override
    public Object apply(Object[] parameter) {
        LinkedList<String> sqlQueryParameter = new LinkedList<String>();
        for (Object par : parameter) {
            sqlQueryParameter.add(par.toString());
        }
        String sqlQuery = OperationDefinition.getSQLString(this.sqlQueryString, sqlQueryParameter);
        logger.debug("Running SQL query:" + sqlQuery);
        ResultSet sqlResult = this.sqlDriver.sqlQuery(sqlQuery);
        Collection<Parameter> resultParameter = OperationDefinition.getParameter(this.resultFilterString);
        try {
            Object[] callParameterInner = new Object[resultParameter.size()];
            int i = 0;
            for (String column : this.getColumnNames(resultParameter)) {
                callParameterInner[i++] = column;
            }
            Object[] callParameter = new Object[]{sqlResult, callParameterInner};
            return ResultFilter.class.getMethod(OperationDefinition.getOperation(this.resultFilterString), this.getMethodParameter(resultParameter)).invoke(null, callParameter);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("Could not invoke dynamic sql operation", (Throwable)e);
            return null;
        }
    }
}

