/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.webserviceclient;

import java.io.Serializable;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class WebServiceRawClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Client client = ClientBuilder.newClient();

    protected Invocation.Builder buildRequest(Client client, String wsURL) {
        WebTarget resource = client.target(wsURL);
        Invocation.Builder request = resource.request();
        request.accept(new String[]{"application/json"});
        return request;
    }

    public String get(String wsURL) {
        Invocation.Builder request = this.buildRequest(this.client, wsURL);
        String result = (String)request.get(String.class);
        return result;
    }

    public String put(String wsURL, String jsonParameter) {
        Invocation.Builder request = this.buildRequest(this.client, wsURL);
        Response rsp = request.put(Entity.entity((Object)jsonParameter.toString(), (String)"application/json"));
        if (rsp.getStatus() != 0 && rsp.getStatus() != 200 && rsp.getStatus() != 201) {
            throw new ServerErrorException(rsp);
        }
        return (String)rsp.readEntity(String.class);
    }

    public String post(String wsURL, String jsonParameter) {
        Invocation.Builder request = this.buildRequest(this.client, wsURL);
        Response rsp = request.post(Entity.entity((Object)jsonParameter, (String)"application/json"));
        if (rsp.getStatus() != 0 && rsp.getStatus() != 200 && rsp.getStatus() != 201) {
            throw new ServerErrorException(rsp);
        }
        return (String)rsp.readEntity(String.class);
    }

    public String patch(String wsURL, String action, String jsonParameter) {
        Response rsp = this.client.target(wsURL).queryParam("action", new Object[]{action}).request().build("PATCH", Entity.text((Object)jsonParameter.toString())).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true).invoke();
        if (rsp.getStatus() != 0 && rsp.getStatus() != 200 && rsp.getStatus() != 201) {
            throw new ServerErrorException(rsp);
        }
        return (String)rsp.readEntity(String.class);
    }

    public String delete(String wsURL) {
        Invocation.Builder request = this.buildRequest(this.client, wsURL);
        String result = (String)request.delete(String.class);
        return result;
    }
}

