/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.processengineconnector;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.eclipse.basyx.components.processengine.connector.DeviceServiceDelegate;
import org.eclipse.basyx.components.processengine.connector.IDeviceServiceExecutor;
import org.eclipse.basyx.regression.support.processengine.stubs.BPMNModelFactory;
import org.eclipse.basyx.regression.support.processengine.stubs.DeviceServiceExecutorStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DynamicActivitiProcessTest {
    ProcessInstance processInstance;
    Deployment deployment;
    BpmnModelInstance modelInstance;
    @Rule
    public ProcessEngineRule camundaRule = new ProcessEngineRule(new StandaloneProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:activiti;DB_CLOSE_DELAY=1000").setJdbcUsername("test").setJdbcPassword("test").setJdbcDriver("org.h2.Driver").setDatabaseSchemaUpdate("true").setJobExecutorActivate(false).buildProcessEngine());

    @Before
    public void deploy() {
        this.modelInstance = new BPMNModelFactory().create("my-process");
        DeviceServiceDelegate.setDeviceServiceExecutor((IDeviceServiceExecutor)new DeviceServiceExecutorStub());
        this.deployment = this.camundaRule.getRepositoryService().createDeployment().addModelInstance("dynamic-model.bpmn", this.modelInstance).name("Dynamic process deployment").deploy();
    }

    @Test
    public void testDynamicDeployPath1() throws Exception {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("coilposition", 1);
        this.processInstance = this.camundaRule.getRuntimeService().startProcessInstanceByKey("my-process", variables);
        HistoryService history = this.camundaRule.getHistoryService();
        List activitiInstances = history.createHistoricActivityInstanceQuery().list();
        String[] expectedSequence = new String[]{"end01", "gateway01", "start01", "t1", "t3", "t4", "t5", "t6", "t7"};
        List<String> expected = Arrays.asList(expectedSequence);
        Stream<HistoricActivityInstance> activityStream = activitiInstances.stream().filter(b -> b.getProcessInstanceId().equals(this.processInstance.getId()));
        List<HistoricActivityInstance> activityInstances = activityStream.collect(Collectors.toList());
        Assert.assertEquals((long)9L, (long)activityInstances.size());
        activityInstances.forEach(x -> {
            String id = x.getActivityId();
            Assert.assertTrue((boolean)expected.contains(id));
            Assert.assertEquals(expected.get(activityInstances.indexOf(x)), (Object)id);
        });
        Assert.assertEquals((long)0L, (long)this.camundaRule.getRuntimeService().createProcessInstanceQuery().count());
        history.deleteHistoricProcessInstance(this.processInstance.getId());
        activitiInstances.forEach(x -> history.deleteHistoricTaskInstance(x.getActivityId()));
    }

    @Test
    public void testDynamicDeployPath2() throws Exception {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("coilposition", 2);
        this.processInstance = this.camundaRule.getRuntimeService().startProcessInstanceByKey("my-process", variables);
        HistoryService history = this.camundaRule.getHistoryService();
        List activitiInstances = history.createHistoricActivityInstanceQuery().list();
        String[] expectedSequence = new String[]{"end01", "gateway01", "start01", "t1", "t2", "t3", "t4", "t5", "t6", "t7"};
        List<String> expected = Arrays.asList(expectedSequence);
        Stream<HistoricActivityInstance> activityStream = activitiInstances.stream().filter(b -> b.getProcessInstanceId().equals(this.processInstance.getId()));
        List<HistoricActivityInstance> activityInstances = activityStream.collect(Collectors.toList());
        Assert.assertEquals((long)10L, (long)activityInstances.size());
        activityInstances.forEach(x -> {
            String id = x.getActivityId();
            Assert.assertTrue((boolean)expected.contains(id));
            Assert.assertEquals(expected.get(activityInstances.indexOf(x)), (Object)id);
        });
        Assert.assertEquals((long)0L, (long)this.camundaRule.getRuntimeService().createProcessInstanceQuery().count());
    }

    @After
    public void generateOutputFiles() throws IOException {
        FileOutputStream output = new FileOutputStream(new File("target/process.bpmn20.xml"));
        Bpmn.writeModelToStream((OutputStream)output, (BpmnModelInstance)this.modelInstance);
        ((OutputStream)output).close();
    }
}

