/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.processengineconnector;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.basyx.components.processengine.connector.DeviceServiceDelegate;
import org.eclipse.basyx.components.processengine.connector.IDeviceServiceExecutor;
import org.eclipse.basyx.regression.support.processengine.stubs.BPMNEngineStub;
import org.eclipse.basyx.regression.support.processengine.stubs.DeviceServiceExecutorStub;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestJavaDelegate {
    GSONTools gson = new GSONTools((GSONToolsFactory)new DefaultTypeFactory());
    private static final String SERVICE_LIFTTO = "liftTo";
    private static final String SERVICE_MOVETO = "moveTo";
    private static final String SERVICE_PROVIDER = "coilcar";

    @Test
    public void testMoveToCall() throws Exception {
        Object[] params = new Object[]{5};
        BPMNEngineStub bpmnstub = new BPMNEngineStub(SERVICE_MOVETO, SERVICE_PROVIDER, this.gson.serialize(new ArrayList<Object>(Arrays.asList(params))), "submodel1");
        DeviceServiceExecutorStub stub = new DeviceServiceExecutorStub();
        DeviceServiceDelegate.setDeviceServiceExecutor((IDeviceServiceExecutor)stub);
        bpmnstub.callJavaDelegate();
        Assert.assertEquals((Object)SERVICE_MOVETO, (Object)stub.getServiceName());
        Assert.assertEquals((Object)SERVICE_PROVIDER, (Object)stub.getServiceProvider());
        Assert.assertArrayEquals((Object[])new Object[]{5}, (Object[])stub.getParams().toArray());
    }

    @Test
    public void testLiftToCall() throws Exception {
        Object[] params = new Object[]{123};
        BPMNEngineStub bpmnstub = new BPMNEngineStub(SERVICE_LIFTTO, SERVICE_PROVIDER, this.gson.serialize(new ArrayList<Object>(Arrays.asList(params))), "submodel1");
        DeviceServiceExecutorStub stub = new DeviceServiceExecutorStub();
        DeviceServiceDelegate.setDeviceServiceExecutor((IDeviceServiceExecutor)stub);
        bpmnstub.callJavaDelegate();
        Assert.assertEquals((Object)SERVICE_LIFTTO, (Object)stub.getServiceName());
        Assert.assertEquals((Object)SERVICE_PROVIDER, (Object)stub.getServiceProvider());
        Assert.assertArrayEquals((Object[])new Object[]{123}, (Object[])stub.getParams().toArray());
    }
}

