/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.sqlproxy;

import java.util.Arrays;
import org.eclipse.basyx.tools.sqlproxy.SQLCollection;
import org.eclipse.basyx.tools.sqlproxy.SQLRootElement;
import org.junit.Assert;
import org.junit.Test;

public class SQLProxyTestCollectionSetOperations {
    protected SQLRootElement sqlRootElement = null;

    @Test
    public void test() throws Exception {
        this.sqlRootElement = new SQLRootElement("postgres", "admin", "//localhost/basyx-map?", "org.postgresql.Driver", "jdbc:postgresql:", "root_el_01");
        this.sqlRootElement.dropTable(1);
        this.sqlRootElement.drop();
        this.sqlRootElement.createRootTableIfNotExists();
        SQLCollection sqlColl = this.sqlRootElement.createCollection(1);
        Assert.assertTrue((sqlColl.size() == 0 ? 1 : 0) != 0);
        sqlColl.add("A");
        Assert.assertTrue((sqlColl.size() == 1 ? 1 : 0) != 0);
        sqlColl.add("B");
        Assert.assertTrue((sqlColl.size() == 2 ? 1 : 0) != 0);
        sqlColl.add("A");
        Assert.assertTrue((sqlColl.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sqlColl.containsAll(Arrays.asList("A", "B", "A")));
        sqlColl.addAll(Arrays.asList("D", "E", "F"));
        Assert.assertTrue((sqlColl.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sqlColl.containsAll(Arrays.asList("A", "B", "A", "D", "E", "F")));
        sqlColl.removeAll(Arrays.asList("D", "F"));
        Assert.assertTrue((sqlColl.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sqlColl.containsAll(Arrays.asList("A", "B", "A", "E")));
        sqlColl.addAll(Arrays.asList(new int[]{1, 2, 3}, new float[]{1.2f, 4.5f}));
        Assert.assertTrue((sqlColl.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sqlColl.containsAll(Arrays.asList(new int[]{1, 2, 3}, new float[]{1.2f, 4.5f})));
        Assert.assertTrue((!sqlColl.containsAll(Arrays.asList(new int[]{1, 2, 3}, new float[]{1.2f, 4.5f}, new int[]{8, 0})) ? 1 : 0) != 0);
        Assert.assertTrue((sqlColl.contains(new int[]{1, 2, 3}) ? 1 : 0) != 0);
        Assert.assertTrue((sqlColl.contains(new float[]{1.2f, 4.5f}) ? 1 : 0) != 0);
        Object[] arr = sqlColl.toArray();
        Assert.assertTrue((arr.length == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)arr[0].equals("A"));
        Assert.assertTrue((boolean)arr[1].equals("B"));
        Assert.assertTrue((boolean)arr[2].equals("A"));
        Assert.assertTrue((boolean)arr[3].equals("E"));
        Assert.assertTrue((boolean)Arrays.equals((int[])arr[4], new int[]{1, 2, 3}));
        Assert.assertTrue((boolean)Arrays.equals((float[])arr[5], new float[]{1.2f, 4.5f}));
        sqlColl.retainAll(Arrays.asList(new int[]{1, 2, 3}, "A"));
        Assert.assertTrue((sqlColl.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((sqlColl.contains(new int[]{1, 2, 3}) ? 1 : 0) != 0);
        Assert.assertTrue((sqlColl.contains("A") ? 1 : 0) != 0);
        this.sqlRootElement.dropTable(1);
        this.sqlRootElement.drop();
    }
}

