/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.sqlproxy;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.basyx.tools.sqlproxy.SQLCollection;
import org.eclipse.basyx.tools.sqlproxy.SQLRootElement;
import org.junit.Assert;
import org.junit.Test;

public class SQLProxyTestCollectionTypes {
    protected SQLRootElement sqlRootElement = null;

    @Test
    public void test() throws Exception {
        this.sqlRootElement = new SQLRootElement("postgres", "admin", "//localhost/basyx-map?", "org.postgresql.Driver", "jdbc:postgresql:", "root_el_01");
        this.sqlRootElement.dropTable(1);
        this.sqlRootElement.drop();
        this.sqlRootElement.createRootTableIfNotExists();
        SQLCollection sqlColl = this.sqlRootElement.createCollection(1);
        Assert.assertTrue((sqlColl.size() == 0 ? 1 : 0) != 0);
        sqlColl.add(null);
        sqlColl.add(14);
        sqlColl.add(-14);
        sqlColl.add(Float.valueOf(14.2f));
        sqlColl.add(Float.valueOf(-14.4f));
        sqlColl.add(13.2);
        sqlColl.add(-13.4);
        sqlColl.add(true);
        sqlColl.add(false);
        sqlColl.add("");
        sqlColl.add("abc");
        sqlColl.add(Character.valueOf('a'));
        sqlColl.add(Character.valueOf('b'));
        Assert.assertTrue((sqlColl.size() == 13 ? 1 : 0) != 0);
        sqlColl.add(new int[]{1, 2, 3});
        sqlColl.add(new float[]{1.2f, 2.2f, 3.4f});
        sqlColl.add(new double[]{3.2, -2.7});
        sqlColl.add(new boolean[]{true, true, false});
        sqlColl.add(new String[]{"x", "y", "z"});
        sqlColl.add(new char[]{'x', 'y', 'z'});
        Assert.assertTrue((sqlColl.size() == 19 ? 1 : 0) != 0);
        Iterator it = sqlColl.iterator();
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((it.next() == null ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)it.next() == 14 ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)it.next() == -14 ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((((Float)it.next()).floatValue() == 14.2f ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((((Float)it.next()).floatValue() == -14.4f ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue(((Double)it.next() == 13.2 ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue(((Double)it.next() == -13.4 ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue(((Boolean)it.next() == true ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue(((Boolean)it.next() == false ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)it.next().equals(""));
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)it.next().equals("abc"));
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((((Character)it.next()).charValue() == 'a' ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((((Character)it.next()).charValue() == 'b' ? 1 : 0) != 0);
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals((int[])it.next(), new int[]{1, 2, 3}));
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals((float[])it.next(), new float[]{1.2f, 2.2f, 3.4f}));
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals((double[])it.next(), new double[]{3.2, -2.7}));
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals((boolean[])it.next(), new boolean[]{true, true, false}));
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals((String[])it.next(), new String[]{"x", "y", "z"}));
        Assert.assertTrue((it.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals((char[])it.next(), new char[]{'x', 'y', 'z'}));
        Assert.assertTrue((!it.hasNext() ? 1 : 0) != 0);
        this.sqlRootElement.dropTable(1);
        this.sqlRootElement.drop();
    }
}

