/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.sqlproxy;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.basyx.tools.sqlproxy.SQLMap;
import org.eclipse.basyx.tools.sqlproxy.SQLRootElement;
import org.junit.Assert;
import org.junit.Test;

public class SQLProxyTestMapSetOperations {
    protected SQLRootElement sqlRootElement = null;

    @Test
    public void test() throws Exception {
        this.sqlRootElement = new SQLRootElement("postgres", "admin", "//localhost/basyx-map?", "org.postgresql.Driver", "jdbc:postgresql:", "root_el_01");
        this.sqlRootElement.dropTable(1);
        this.sqlRootElement.drop();
        this.sqlRootElement.createRootTableIfNotExists();
        SQLMap sqlMap = this.sqlRootElement.createMap(1);
        sqlMap.clear();
        HashMap<String, Integer> addedElements1 = new HashMap<String, Integer>();
        addedElements1.put("El1", 1);
        addedElements1.put("El2", 2);
        addedElements1.put("El3", 3);
        sqlMap.putAll(addedElements1);
        Assert.assertTrue((!sqlMap.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((sqlMap.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)sqlMap.get("El1") == 1 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)sqlMap.get("El2") == 2 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)sqlMap.get("El3") == 3 ? 1 : 0) != 0);
        HashMap<String, Comparable<Character>> addedElements2 = new HashMap<String, Comparable<Character>>();
        addedElements2.put("El1", Character.valueOf('x'));
        addedElements2.put("El4", Integer.valueOf(4));
        addedElements2.put("El5", Integer.valueOf(5));
        sqlMap.putAll(addedElements2);
        Assert.assertTrue((sqlMap.size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((((Character)sqlMap.get("El1")).charValue() == 'x' ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)sqlMap.get("El2") == 2 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)sqlMap.get("El3") == 3 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)sqlMap.get("El4") == 4 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)sqlMap.get("El5") == 5 ? 1 : 0) != 0);
        sqlMap.put("El5", "xy");
        Assert.assertTrue((sqlMap.size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sqlMap.get("El5").equals("xy"));
        HashSet<String> keySetBaseLine = new HashSet<String>();
        keySetBaseLine.add("El1");
        keySetBaseLine.add("El2");
        keySetBaseLine.add("El3");
        keySetBaseLine.add("El4");
        keySetBaseLine.add("El5");
        Assert.assertTrue((boolean)sqlMap.keySet().containsAll(keySetBaseLine));
        Assert.assertTrue((boolean)keySetBaseLine.containsAll(sqlMap.keySet()));
        LinkedList<Object> valuesBaseLine1 = new LinkedList<Object>();
        valuesBaseLine1.add(Character.valueOf('x'));
        valuesBaseLine1.add(2);
        valuesBaseLine1.add(3);
        valuesBaseLine1.add(4);
        valuesBaseLine1.add("xy");
        Assert.assertTrue((boolean)sqlMap.values().containsAll(valuesBaseLine1));
        Assert.assertTrue((boolean)valuesBaseLine1.containsAll(sqlMap.values()));
        sqlMap.put("El3", 2);
        LinkedList<Object> valuesBaseLine2 = new LinkedList<Object>();
        valuesBaseLine2.add(Character.valueOf('x'));
        valuesBaseLine2.add(2);
        valuesBaseLine2.add(2);
        valuesBaseLine2.add(4);
        valuesBaseLine2.add("xy");
        Assert.assertTrue((boolean)sqlMap.values().containsAll(valuesBaseLine2));
        Assert.assertTrue((boolean)valuesBaseLine2.containsAll(sqlMap.values()));
        HashSet<AbstractMap.SimpleEntry<String, Object>> entrySetBaseLine1 = new HashSet<AbstractMap.SimpleEntry<String, Object>>();
        entrySetBaseLine1.add(new AbstractMap.SimpleEntry<String, Character>("El1", Character.valueOf('x')));
        entrySetBaseLine1.add(new AbstractMap.SimpleEntry<String, Integer>("El2", 2));
        entrySetBaseLine1.add(new AbstractMap.SimpleEntry<String, Integer>("El3", 2));
        entrySetBaseLine1.add(new AbstractMap.SimpleEntry<String, Integer>("El4", 4));
        entrySetBaseLine1.add(new AbstractMap.SimpleEntry<String, String>("El5", "xy"));
        Assert.assertTrue((boolean)sqlMap.entrySet().containsAll(entrySetBaseLine1));
        Assert.assertTrue((boolean)entrySetBaseLine1.containsAll(sqlMap.entrySet()));
        sqlMap.clear();
        Assert.assertTrue((sqlMap.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sqlMap.isEmpty());
        this.sqlRootElement.dropTable(1);
        this.sqlRootElement.drop();
    }
}

