/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.support.bundle;

import java.util.Collections;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.eclipse.basyx.support.bundle.AASBundleDescriptorFactory;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.junit.Assert;
import org.junit.Test;

public class TestAASBundleDescriptorFactory {
    @Test
    public void testDescriptorCreation() {
        String aasId = "aasId";
        AssetAdministrationShell shell = new AssetAdministrationShell();
        shell.setIdentification((IIdentifier)new Identifier(IdentifierType.CUSTOM, aasId));
        String smId = "smId";
        Submodel sm = new Submodel();
        sm.setIdShort(smId);
        sm.setIdentification(IdentifierType.IRI, "aasIdIRI");
        AASBundle bundle = new AASBundle((IAssetAdministrationShell)shell, Collections.singleton(sm));
        String basePath = "http://localhost:4040/test";
        AASDescriptor desc = AASBundleDescriptorFactory.createAASDescriptor((AASBundle)bundle, (String)basePath);
        String aasPath = VABPathTools.concatenatePaths((String[])new String[]{basePath, aasId, "aas"});
        String smPath = VABPathTools.concatenatePaths((String[])new String[]{aasPath, "submodels", sm.getIdShort(), "submodel"});
        Assert.assertEquals((Object)aasPath, (Object)desc.getFirstEndpoint());
        Assert.assertEquals((Object)smPath, (Object)desc.getSubmodelDescriptorFromIdShort(smId).getFirstEndpoint());
    }
}

