/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.support.bundle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.aas.aggregator.AASAggregator;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.aggregator.proxy.AASAggregatorProxy;
import org.eclipse.basyx.aas.aggregator.restapi.AASAggregatorProvider;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.memory.InMemoryRegistry;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.eclipse.basyx.support.bundle.AASBundleHelper;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAASBundleHelper {
    private static final String AAS_ID = "TestAAS";
    private static final String SM_ID = "TestSM";
    private AASAggregatorProxy aggregator;
    private List<AASBundle> bundles;
    private AASAggregatorProvider provider;

    @Before
    public void init() {
        this.provider = new AASAggregatorProvider((IAASAggregator)new AASAggregator());
        this.aggregator = new AASAggregatorProxy((IModelProvider)new VABElementProxy("/shells", (IModelProvider)this.provider));
        this.bundles = new ArrayList<AASBundle>();
    }

    @Test
    public void testIntegrationOfExistingAASAndSM() {
        AASBundle bundle = this.getTestBundle();
        this.bundles.add(bundle);
        AssetAdministrationShell aas = (AssetAdministrationShell)bundle.getAAS();
        Set submodels = bundle.getSubmodels();
        Submodel sm = (Submodel)submodels.iterator().next();
        this.pushAAS(aas);
        this.pushSubmodel(sm, aas.getIdentification());
        Assert.assertFalse((boolean)AASBundleHelper.integrate((IAASAggregator)this.aggregator, this.bundles));
        this.checkAggregatorContent();
    }

    @Test
    public void testIntegrationOfExistingAASAndNonexistingSM() {
        AASBundle bundle = this.getTestBundle();
        this.bundles.add(bundle);
        AssetAdministrationShell aas = (AssetAdministrationShell)bundle.getAAS();
        this.pushAAS(aas);
        Assert.assertTrue((boolean)AASBundleHelper.integrate((IAASAggregator)this.aggregator, this.bundles));
        this.checkAggregatorContent();
    }

    @Test
    public void testIntegrationOfNonexistingAASAndSM() {
        AASBundle bundle = this.getTestBundle();
        this.bundles.add(bundle);
        Assert.assertTrue((boolean)AASBundleHelper.integrate((IAASAggregator)this.aggregator, this.bundles));
        this.checkAggregatorContent();
    }

    @Test
    public void testIntegrationOfNonexistingAASAndSMWithRegistry() {
        InMemoryRegistry registry = new InMemoryRegistry();
        this.provider = new AASAggregatorProvider((IAASAggregator)new AASAggregator((IAASRegistry)registry));
        this.aggregator = new AASAggregatorProxy((IModelProvider)new VABElementProxy("/shells", (IModelProvider)this.provider));
        AASBundle bundle = this.getTestBundle();
        this.bundles.add(bundle);
        Assert.assertTrue((boolean)AASBundleHelper.integrate((IAASAggregator)this.aggregator, this.bundles));
        this.checkAggregatorContent();
    }

    private void checkAggregatorContent() {
        IAssetAdministrationShell aas = this.aggregator.getAAS((IIdentifier)new Identifier(IdentifierType.CUSTOM, AAS_ID));
        Assert.assertEquals((Object)AAS_ID, (Object)aas.getIdShort());
        IModelProvider provider = this.aggregator.getAASProvider((IIdentifier)new Identifier(IdentifierType.CUSTOM, AAS_ID));
        Submodel sm = SubmodelElementMapCollectionConverter.mapToSM((Map)((Map)provider.getValue("/aas/submodels/TestSM")));
        Assert.assertEquals((Object)SM_ID, (Object)sm.getIdentification().getId());
    }

    private void pushAAS(AssetAdministrationShell aas) {
        this.aggregator.createAAS(aas);
    }

    private void pushSubmodel(Submodel sm, IIdentifier aasIdentifier) {
        this.provider.setValue("/shells/" + aasIdentifier.getId() + "/aas/submodels/" + sm.getIdShort(), (Object)sm);
    }

    private AASBundle getTestBundle() {
        Submodel sm = new Submodel();
        sm.setIdShort(SM_ID);
        sm.setIdentification(IdentifierType.CUSTOM, SM_ID);
        AssetAdministrationShell aas = new AssetAdministrationShell();
        aas.setIdentification(IdentifierType.CUSTOM, AAS_ID);
        aas.setIdShort(AAS_ID);
        aas.addSubmodel(sm);
        return new AASBundle((IAssetAdministrationShell)aas, new HashSet<Submodel>(Arrays.asList(sm)));
    }
}

