/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;

public class BaSyxSQLConfiguration
extends BaSyxConfiguration {
    public static final String ENV_PREFIX = "BaSyxSQL_";
    public static final String DEFAULT_USER = "postgres";
    public static final String DEFAULT_PASS = "admin";
    public static final String DEFAULT_PATH = "//localhost/basyx-directory?";
    public static final String DEFAULT_DRV = "org.postgresql.Driver";
    public static final String DEFAULT_PREFIX = "jdbc:postgresql:";
    public static final String USER = "dbuser";
    public static final String PASS = "dbpass";
    public static final String PATH = "dburl";
    public static final String DRIVER = "sqlDriver";
    public static final String PREFIX = "sqlPrefix";
    public static final String DEFAULT_CONFIG_PATH = "sql.properties";
    public static final String DEFAULT_FILE_KEY = "BASYX_SQL";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(USER, DEFAULT_USER);
        defaultProps.put(PASS, DEFAULT_PASS);
        defaultProps.put(PATH, DEFAULT_PATH);
        defaultProps.put(DRIVER, DEFAULT_DRV);
        defaultProps.put(PREFIX, DEFAULT_PREFIX);
        return defaultProps;
    }

    public BaSyxSQLConfiguration(Map<String, String> values) {
        super(values);
    }

    public BaSyxSQLConfiguration() {
        super(BaSyxSQLConfiguration.getDefaultProperties());
    }

    public BaSyxSQLConfiguration(String user, String pass, String path, String driver, String prefix) {
        this();
        this.setUser(user);
        this.setPass(pass);
        this.setPath(path);
        this.setDriver(driver);
        this.setPrefix(prefix);
    }

    public void loadFromEnvironmentVariables() {
        String[] properties = new String[]{USER, PASS, PATH, DRIVER, PREFIX};
        this.loadFromEnvironmentVariables(ENV_PREFIX, properties);
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
        this.loadFromEnvironmentVariables();
    }

    public String getUser() {
        return this.getProperty(USER);
    }

    public void setUser(String user) {
        this.setProperty(USER, user);
    }

    public String getPass() {
        return this.getProperty(PASS);
    }

    public void setPass(String pass) {
        this.setProperty(PASS, pass);
    }

    public String getPath() {
        return this.getProperty(PATH);
    }

    public void setPath(String path) {
        this.setProperty(PATH, path);
    }

    public String getDriver() {
        return this.getProperty(DRIVER);
    }

    public void setDriver(String driver) {
        this.setProperty(DRIVER, driver);
    }

    public String getPrefix() {
        return this.getProperty(PREFIX);
    }

    public void setPrefix(String prefix) {
        this.setProperty(PREFIX, prefix);
    }
}

