/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.sql.query;

import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.basyx.components.tools.propertyfile.opdef.OperationDefinition;
import org.eclipse.basyx.tools.sql.driver.ISQLDriver;
import org.eclipse.basyx.tools.sql.query.DynamicSQLRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSQLUpdate
extends DynamicSQLRunner
implements Consumer<Map<String, Object>> {
    private static Logger logger = LoggerFactory.getLogger(DynamicSQLUpdate.class);
    protected String sqlQueryString = null;

    public DynamicSQLUpdate(ISQLDriver driver, String query) {
        super(driver);
        this.sqlQueryString = query;
    }

    public DynamicSQLUpdate(String path, String user, String pass, String qryPfx, String qDrvCls, String query) {
        super(path, user, pass, qryPfx, qDrvCls);
        this.sqlQueryString = query;
    }

    @Override
    public void accept(Map<String, Object> parameter) {
        logger.debug("(Parameters) Running SQL update: " + parameter);
        String sqlQuery = OperationDefinition.getSQLString(this.sqlQueryString, parameter);
        logger.debug("(Query) Running SQL update:" + sqlQuery);
        this.sqlDriver.sqlUpdate(sqlQuery);
    }
}

