/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.sqlproxy;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.tools.sql.driver.ISQLDriver;
import org.eclipse.basyx.tools.sql.query.DynamicSQLQuery;
import org.eclipse.basyx.tools.sql.query.DynamicSQLUpdate;
import org.eclipse.basyx.tools.sqlproxy.SQLProxy;
import org.eclipse.basyx.tools.sqlproxy.SQLRootElement;
import org.eclipse.basyx.tools.sqlproxy.SQLTableRow;

public class SQLCollection
extends SQLProxy
implements Collection<Object> {
    public SQLCollection(SQLRootElement rootElement, int tableId) {
        super(rootElement.getDriver(), rootElement.getSqlTableID() + "__" + tableId, rootElement);
    }

    public SQLCollection(SQLRootElement rootElement, String tableIdWithprefix) {
        super(rootElement.getDriver(), tableIdWithprefix, rootElement);
    }

    @Override
    public int size() {
        String queryString = "SELECT * FROM elements." + this.getSqlTableID();
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(this.getDriver(), queryString, "mapArray(name:String,value:String,type:String)");
        ResultSet result = dynQuery.getRaw();
        return this.getSize(result);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object value) {
        return this.contains(this.getDriver(), value);
    }

    protected boolean contains(ISQLDriver drv, Object value) {
        String queryString = "SELECT * FROM elements." + this.getSqlTableID() + " WHERE value='$value'";
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(drv, queryString, "mapArray(value:String,type:String)");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("value", SQLTableRow.getValueAsString(value));
        ResultSet result = dynQuery.getRaw(parameter);
        return this.getSize(result) > 0;
    }

    @Override
    public Iterator<Object> iterator() {
        final List sqlResult = (List)this.getMapColumnRaw(this.getSqlTableID(), "type", "value");
        Iterator<Object> it = new Iterator<Object>(){
            private int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < sqlResult.size();
            }

            @Override
            public Object next() {
                Map singleResult = (Map)sqlResult.get(this.currentIndex++);
                return SQLTableRow.getValueFromString(SQLCollection.this.sqlRootElement, Integer.parseInt((String)singleResult.get("type")), (String)singleResult.get("value"));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }

    @Override
    public Object[] toArray() {
        List sqlResult = (List)this.getMapColumnRaw(this.getSqlTableID(), "type", "value");
        Object[] result = new Object[sqlResult.size()];
        int counter = 0;
        for (Map singleResult : sqlResult) {
            result[counter++] = SQLTableRow.getValueFromString(this.sqlRootElement, Integer.parseInt((String)singleResult.get("type")), (String)singleResult.get("value"));
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Object[] result = array;
        List sqlResult = (List)this.getMapColumnRaw(this.getSqlTableID(), "type", "value");
        if (result.length < sqlResult.size()) {
            result = (Object[])Array.newInstance(array.getClass().getComponentType(), sqlResult.size());
        }
        int counter = 0;
        for (Map singleResult : sqlResult) {
            result[counter++] = SQLTableRow.getValueFromString(this.sqlRootElement, Integer.parseInt((String)singleResult.get("type")), (String)singleResult.get("value"));
        }
        return result;
    }

    @Override
    public boolean add(Object value) {
        this.addToCollectionSimple(this.getSqlTableID(), new SQLTableRow(value));
        return true;
    }

    @Override
    public boolean remove(Object value) {
        if (this.contains(this.getDriver(), value)) {
            String updateString = "DELETE FROM elements." + this.getSqlTableID() + " WHERE value='$value'";
            DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(this.getDriver(), updateString);
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("value", SQLTableRow.getValueAsString(value));
            dynUpdate.accept((Map<String, Object>)parameter);
            return true;
        }
        return false;
    }

    protected boolean removeIfContained(ISQLDriver sqlDrv, Object value) {
        if (this.contains(sqlDrv, value)) {
            String updateString = "DELETE FROM elements." + this.getSqlTableID() + " WHERE value='$value'";
            DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(sqlDrv, updateString);
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("value", SQLTableRow.getValueAsString(value));
            dynUpdate.accept((Map<String, Object>)parameter);
            return true;
        }
        return false;
    }

    protected boolean removeSerValueIfContained(ISQLDriver sqlDrv, String value) {
        if (this.contains(sqlDrv, value)) {
            String updateString = "DELETE FROM elements." + this.getSqlTableID() + " WHERE value='$value'";
            DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(sqlDrv, updateString);
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("value", value);
            dynUpdate.accept((Map<String, Object>)parameter);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        boolean containsAllFlag = true;
        try {
            for (Object val : values) {
                if (this.contains(this.getDriver(), val)) continue;
                containsAllFlag = false;
            }
            return containsAllFlag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean addAll(Collection<? extends Object> values) {
        for (Object object : values) {
            this.addToCollectionSimple(this.getDriver(), this.getSqlTableID(), new SQLTableRow(object));
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        boolean performedChange = false;
        for (Object val : values) {
            performedChange |= this.removeIfContained(this.getDriver(), val);
        }
        return performedChange;
    }

    @Override
    public boolean retainAll(Collection<?> values) {
        boolean performedChange = false;
        LinkedList<String> serValues = new LinkedList<String>();
        for (Object val : values) {
            serValues.add(SQLTableRow.getValueAsString(val));
        }
        List sqlResult = (List)this.getMapColumnRaw(this.getDriver(), this.getSqlTableID(), "type", "value");
        for (Map row : sqlResult) {
            if (serValues.contains((String)row.get("value"))) continue;
            performedChange |= this.removeSerValueIfContained(this.getDriver(), (String)row.get("value"));
        }
        return performedChange;
    }

    @Override
    public void clear() {
        String updateString = "DELETE FROM elements." + this.getSqlTableID();
        DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(this.getDriver(), updateString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        dynUpdate.accept((Map<String, Object>)parameter);
    }
}

