/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.registry;

import org.eclipse.basyx.aas.registration.api.IAASRegistryService;
import org.eclipse.basyx.aas.registration.proxy.AASRegistryProxy;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxDockerConfiguration;
import org.eclipse.basyx.testsuite.regression.aas.registration.TestRegistryProviderSuite;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITRegistry
extends TestRegistryProviderSuite {
    private static Logger logger = LoggerFactory.getLogger(ITRegistry.class);
    private static String registryUrl;

    @BeforeClass
    public static void setUpClass() {
        logger.info("Running integration test...");
        logger.info("Loading servlet configuration");
        BaSyxContextConfiguration contextConfig = new BaSyxContextConfiguration();
        contextConfig.loadFromResource("context.properties");
        logger.info("Loading docker configuration");
        BaSyxDockerConfiguration dockerConfig = new BaSyxDockerConfiguration();
        dockerConfig.loadFromResource(".env");
        registryUrl = "http://localhost:" + dockerConfig.getHostPort() + contextConfig.getContextPath();
        logger.info("Registry URL for integration test: " + registryUrl);
    }

    protected IAASRegistryService getRegistryService() {
        return new AASRegistryProxy(registryUrl);
    }
}

