/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry;

import javax.servlet.http.HttpServlet;
import org.eclipse.basyx.components.IComponent;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxSQLConfiguration;
import org.eclipse.basyx.components.registry.configuration.BaSyxRegistryConfiguration;
import org.eclipse.basyx.components.registry.configuration.RegistryBackend;
import org.eclipse.basyx.components.registry.servlet.InMemoryRegistryServlet;
import org.eclipse.basyx.components.registry.servlet.MongoDBRegistryServlet;
import org.eclipse.basyx.components.registry.servlet.SQLRegistryServlet;
import org.eclipse.basyx.vab.protocol.http.server.AASHTTPServer;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryComponent
implements IComponent {
    private static Logger logger = LoggerFactory.getLogger(RegistryComponent.class);
    private AASHTTPServer server;
    private BaSyxContextConfiguration contextConfig;
    private BaSyxRegistryConfiguration registryConfig;
    private BaSyxMongoDBConfiguration mongoDBConfig;
    private BaSyxSQLConfiguration sqlConfig;

    public RegistryComponent() {
        this.contextConfig = new BaSyxContextConfiguration();
        this.registryConfig = new BaSyxRegistryConfiguration();
    }

    public RegistryComponent(BaSyxContextConfiguration contextConfig) {
        this.contextConfig = contextConfig;
        this.registryConfig = new BaSyxRegistryConfiguration(RegistryBackend.INMEMORY);
    }

    public RegistryComponent(BaSyxContextConfiguration contextConfig, BaSyxMongoDBConfiguration mongoDBConfig) {
        this.contextConfig = contextConfig;
        this.registryConfig = new BaSyxRegistryConfiguration(RegistryBackend.MONGODB);
        this.mongoDBConfig = mongoDBConfig;
    }

    public RegistryComponent(BaSyxContextConfiguration contextConfig, BaSyxSQLConfiguration sqlConfig) {
        this.contextConfig = contextConfig;
        this.registryConfig = new BaSyxRegistryConfiguration(RegistryBackend.SQL);
        this.sqlConfig = sqlConfig;
    }

    public RegistryComponent(BaSyxContextConfiguration contextConfig, BaSyxRegistryConfiguration registryConfig) {
        this.contextConfig = contextConfig;
        this.registryConfig = registryConfig;
    }

    public void startComponent() {
        BaSyxContext context = this.contextConfig.createBaSyxContext();
        context.addServletMapping("/*", this.loadRegistryServlet());
        this.server = new AASHTTPServer(context);
        this.server.start();
        logger.info("Registry server started");
    }

    private HttpServlet loadRegistryServlet() {
        HttpServlet registryServlet = null;
        RegistryBackend backendType = this.registryConfig.getRegistryBackend();
        switch (backendType) {
            case MONGODB: {
                registryServlet = this.loadMongoDBRegistryServlet();
                break;
            }
            case SQL: {
                registryServlet = this.loadSQLRegistryServlet();
                break;
            }
            case INMEMORY: {
                registryServlet = this.loadInMemoryRegistryServlet();
            }
        }
        return registryServlet;
    }

    private HttpServlet loadSQLRegistryServlet() {
        BaSyxSQLConfiguration config;
        logger.info("Loading SQLRegistry");
        if (this.sqlConfig == null) {
            config = new BaSyxSQLConfiguration();
            config.loadFromDefaultSource();
        } else {
            config = this.sqlConfig;
        }
        return new SQLRegistryServlet(config);
    }

    private HttpServlet loadMongoDBRegistryServlet() {
        BaSyxMongoDBConfiguration config;
        logger.info("Loading MongoDBRegistry");
        if (this.mongoDBConfig == null) {
            config = new BaSyxMongoDBConfiguration();
            config.loadFromDefaultSource();
        } else {
            config = this.mongoDBConfig;
        }
        return new MongoDBRegistryServlet(config);
    }

    private HttpServlet loadInMemoryRegistryServlet() {
        logger.info("Loading InMemoryRegistry");
        return new InMemoryRegistryServlet();
    }

    public void stopComponent() {
        this.server.shutdown();
        logger.info("Registry server stopped");
    }
}

