/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.configuration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.registry.configuration.RegistryBackend;

public class BaSyxRegistryConfiguration
extends BaSyxConfiguration {
    public static final String DEFAULT_BACKEND = RegistryBackend.INMEMORY.toString();
    public static final String BACKEND = "registry.backend";
    public static final String DEFAULT_CONFIG_PATH = "registry.properties";
    public static final String DEFAULT_FILE_KEY = "BASYX_REGISTRY";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(BACKEND, DEFAULT_BACKEND);
        return defaultProps;
    }

    public BaSyxRegistryConfiguration() {
        super(BaSyxRegistryConfiguration.getDefaultProperties());
    }

    public BaSyxRegistryConfiguration(RegistryBackend backend) {
        super(BaSyxRegistryConfiguration.getDefaultProperties());
        this.setRegistryBackend(backend);
    }

    public BaSyxRegistryConfiguration(Map<String, String> values) {
        super(values);
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
    }

    public RegistryBackend getRegistryBackend() {
        return RegistryBackend.fromString(this.getProperty(BACKEND));
    }

    public void setRegistryBackend(RegistryBackend backend) {
        this.setProperty(BACKEND, backend.toString());
    }
}

