/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.registry;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxDockerConfiguration;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.tools.webserviceclient.WebServiceRawClient;
import org.eclipse.basyx.vab.coder.json.metaprotocol.MetaprotocolHandler;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITRegistryRaw {
    private static Logger logger = LoggerFactory.getLogger(ITRegistryRaw.class);
    private static final GSONTools serializer = new GSONTools((GSONToolsFactory)new DefaultTypeFactory());
    private static final MetaprotocolHandler handler = new MetaprotocolHandler();
    private static final WebServiceRawClient client = new WebServiceRawClient();
    private static String registryUrl;
    private static final IIdentifier id1;
    private static final String endpoint1 = "www.endpoint.de";
    private static final AASDescriptor aasDescriptor1;
    private static final String serializedDescriptor1;
    private static final IIdentifier id2;
    private static final String endpoint2 = "www.endpoint2.de";
    private static final String endpoint2b = "www.endpoint2.de";
    private static final AASDescriptor aasDescriptor2;
    private static final AASDescriptor aasDescriptor2b;
    private static final String serializedDescriptor2;
    private static final String serializedDescriptor2b;
    private static final IIdentifier idUnknown;
    private static String aasUrl1;
    private static String aasUrl2;
    private static String aasUrlUnknown;

    @BeforeClass
    public static void setUpClass() throws UnsupportedEncodingException {
        logger.info("Running integration test...");
        logger.info("Loading servlet configuration");
        BaSyxContextConfiguration contextConfig = new BaSyxContextConfiguration();
        contextConfig.loadFromResource("context.properties");
        logger.info("Loading docker configuration");
        BaSyxDockerConfiguration dockerConfig = new BaSyxDockerConfiguration();
        dockerConfig.loadFromResource(".env");
        registryUrl = "http://localhost:" + dockerConfig.getHostPort() + contextConfig.getContextPath() + "/api/v1/registry/";
        logger.info("Registry URL for integration test: " + registryUrl);
        aasUrl1 = registryUrl + URLEncoder.encode(id1.getId(), "UTF-8");
        aasUrl2 = registryUrl + URLEncoder.encode(id2.getId(), "UTF-8");
        aasUrlUnknown = registryUrl + URLEncoder.encode(idUnknown.getId(), "UTF-8");
        logger.info("Registry URL for integration test: " + registryUrl);
    }

    @Before
    public void setUp() {
        client.put(aasUrl1, serializedDescriptor1);
        client.put(aasUrl2, serializedDescriptor2);
    }

    @After
    public void tearDown() throws UnsupportedEncodingException {
        try {
            client.delete(aasUrl1);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            client.delete(aasUrl2);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetterCalls() {
        Collection result = (Collection)this.getResult(client.get(registryUrl));
        Assert.assertEquals((long)2L, (long)result.size());
        try {
            result = new AASDescriptor((Map)this.getResult(client.get(aasUrl1)));
            Assert.assertEquals((Object)id1.getId(), (Object)result.getIdentifier().getId());
        }
        catch (Exception e) {
            Assert.fail((String)("Get specific AAS test case did throw exception:" + e));
        }
        try {
            result = new AASDescriptor((Map)this.getResult(client.get(aasUrl2)));
            Assert.assertEquals((Object)id2.getId(), (Object)result.getIdentifier().getId());
        }
        catch (Exception e) {
            Assert.fail((String)("Get specific AAS test case did throw exception:" + e));
        }
    }

    @Test
    public void testUpdateCall() throws UnsupportedEncodingException {
        client.put(aasUrl2, serializedDescriptor2b);
        AASDescriptor result = new AASDescriptor((Map)this.getResult(client.get(aasUrl2)));
        Assert.assertEquals((Object)"www.endpoint2.de", (Object)result.getFirstEndpoint());
    }

    @Test
    public void testCreateDeleteCall() throws UnsupportedEncodingException {
        client.delete(aasUrl2);
        try {
            this.getResult(client.get(aasUrl2));
            Assert.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        client.put(aasUrl2, serializedDescriptor2);
        AASDescriptor result2 = new AASDescriptor((Map)this.getResult(client.get(aasUrl2)));
        Assert.assertEquals((Object)"www.endpoint2.de", (Object)result2.getFirstEndpoint());
        client.delete(aasUrl2);
        try {
            this.getResult(client.get(aasUrl2));
            Assert.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test(expected=NotFoundException.class)
    public void testNonWorkingCalls() throws UnsupportedEncodingException {
        this.getResult(client.get(aasUrlUnknown));
        Assert.fail();
    }

    private <T> T getResult(String res) {
        try {
            return (T)handler.deserialize(res);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    static {
        id1 = new ModelUrn("urn:de.FHG:es.iese:aas:0.98:5:lab:microscope#A-166");
        aasDescriptor1 = new AASDescriptor(id1, endpoint1);
        serializedDescriptor1 = serializer.serialize((Object)aasDescriptor1);
        id2 = new ModelUrn("urn:de.FHG:es.iese:aas:0.98:5:lab:microscope#A-167");
        aasDescriptor2 = new AASDescriptor(id2, "www.endpoint2.de");
        aasDescriptor2b = new AASDescriptor(id2, "www.endpoint2.de");
        serializedDescriptor2 = serializer.serialize((Object)aasDescriptor2);
        serializedDescriptor2b = serializer.serialize((Object)aasDescriptor2b);
        idUnknown = new ModelUrn("urn:de.FHG:es.iese:aas:0.98:5:lab:microscope#A-168");
    }
}

