/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.registry;

import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.components.configuration.BaSyxSQLConfiguration;
import org.eclipse.basyx.components.registry.sql.SQLRegistry;
import org.eclipse.basyx.testsuite.regression.aas.registration.TestRegistryProviderSuite;
import org.eclipse.basyx.tools.sqlproxy.SQLRootElement;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSQLRegistryProvider
extends TestRegistryProviderSuite {
    @BeforeClass
    public static void setUpClass() {
        SQLRootElement root = TestSQLRegistryProvider.getSQLRootElement();
        root.drop();
    }

    @AfterClass
    public static void tearDownClass() {
        SQLRootElement root = TestSQLRegistryProvider.getSQLRootElement();
        root.drop();
    }

    protected static SQLRootElement getSQLRootElement() {
        BaSyxSQLConfiguration config = new BaSyxSQLConfiguration();
        config.loadFromResource("sql.properties");
        String path = config.getPath();
        String user = config.getUser();
        String pass = config.getPass();
        String qryPfx = config.getPrefix();
        String qDrvCls = config.getDriver();
        return new SQLRootElement(user, pass, path, qDrvCls, qryPfx, "root_registry");
    }

    protected IAASRegistry getRegistryService() {
        BaSyxSQLConfiguration sqlConfig = new BaSyxSQLConfiguration();
        sqlConfig.loadFromResource("sql.properties");
        return new SQLRegistry(sqlConfig);
    }

    @Test
    public void testPersistency() {
        BaSyxSQLConfiguration sqlConfig = new BaSyxSQLConfiguration();
        sqlConfig.loadFromResource("sql.properties");
        SQLRegistry registry = new SQLRegistry(sqlConfig);
        AASDescriptor aasDesc2 = new AASDescriptor(this.aasIdShort2, this.aasId2, (IAsset)this.asset2, this.aasEndpoint2);
        this.proxy.register(aasDesc2);
        AASDescriptor descriptor = registry.lookupAAS(this.aasId1);
        super.validateDescriptor1(descriptor);
        AASDescriptor descriptor2 = registry.lookupAAS(this.aasId2);
        super.validateDescriptor2(descriptor2);
    }
}

