/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport.connectors.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.rabbitmq.RabbitMqAmqpTransportConnector;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.transport.AbstractTransportConnectorTest;
import test.de.iip_ecosphere.platform.transport.ProductJsonSerializer;
import test.de.iip_ecosphere.platform.transport.ProductProtobufSerializer;
import test.de.iip_ecosphere.platform.transport.connectors.rabbitmq.TestQpidServer;

public class RabbitMqAmqpTransportConnectorTest {
    @Test
    public void testRabbitMqConnector() throws IOException {
        TransportFactory.ConnectorCreator old = TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)new TransportFactory.ConnectorCreator(){

            public TransportConnector createConnector() {
                return new FakeAuthConnector();
            }

            public String getName() {
                return "AMQP";
            }
        });
        Assert.assertEquals((Object)"AMQP", (Object)TransportFactory.getConnectorName());
        ServerAddress addr = new ServerAddress(Schema.IGNORE);
        TestQpidServer server = new TestQpidServer(addr);
        server.start();
        AbstractTransportConnectorTest.doTest((ServerAddress)addr, ProductJsonSerializer.class);
        AbstractTransportConnectorTest.doTest((ServerAddress)addr, ProductProtobufSerializer.class);
        server.stop(true);
        TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)old);
    }

    private static class FakeAuthConnector
    extends RabbitMqAmqpTransportConnector {
        private FakeAuthConnector() {
        }

        protected void configureFactory(ConnectionFactory factory) {
            factory.setUsername("user");
            factory.setPassword("pwd");
        }
    }
}

