/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport.connectors.rabbitmq;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.apache.qpid.server.SystemLauncher;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.transport.AbstractTestServer;

public class TestQpidServer
extends AbstractTestServer {
    private SystemLauncher systemLauncher;
    private ServerAddress addr;

    public TestQpidServer(ServerAddress addr) {
        this.addr = addr;
    }

    public Server start() {
        try {
            System.setProperty("qpid.amqp_port", Integer.toString(this.addr.getPort()));
            this.systemLauncher = new SystemLauncher();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            File f = new File(TestQpidServer.getConfigDir((String)"./src/test"), "config.json");
            System.out.println(f);
            URL initialConfig = f.toURI().toURL();
            System.out.println(initialConfig);
            attributes.put("type", "Memory");
            attributes.put("initialConfigurationLocation", initialConfig.toExternalForm());
            attributes.put("startupLoggedToSystemOut", true);
            attributes.put("initialSystemPropertiesLocation", "");
            System.out.println(attributes);
            this.systemLauncher.startup(attributes);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(e.getMessage(), (Throwable)e);
        }
        return this;
    }

    public void stop(boolean dispose) {
        this.systemLauncher.shutdown();
    }
}

