/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport.connectors.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.rabbitmq.RabbitMqAmqpTransportConnector;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.test.amqp.qpid.TestQpidServer;
import test.de.iip_ecosphere.platform.transport.AbstractTransportConnectorTest;
import test.de.iip_ecosphere.platform.transport.ProductJsonSerializer;
import test.de.iip_ecosphere.platform.transport.ProductProtobufSerializer;

public class RabbitMqAmqpTransportConnectorTest {
    @Test
    public void testRabbitMqConnector() throws IOException {
        TestQpidServer.setConfigDir(null);
        this.doTest(null);
    }

    @Test
    public void testRabbitMqTlsConnector() throws IOException {
        File secCfg = new File("./src/test/secCfg");
        TestQpidServer.setConfigDir((File)secCfg);
        this.doTest(new AbstractTransportConnectorTest.TransportParameterConfigurer(){

            public void configure(TransportParameter.TransportParameterBuilder builder) {
                builder.setAuthenticationKey("amqp");
                builder.setKeystoreKey("amqpKeyStore");
            }
        });
        TestQpidServer.setConfigDir(null);
    }

    private void doTest(AbstractTransportConnectorTest.TransportParameterConfigurer configurer) throws IOException {
        TransportFactory.ConnectorCreator old = TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)new TransportFactory.ConnectorCreator(){

            public TransportConnector createConnector() {
                return new FakeAuthConnector();
            }

            public String getName() {
                return "AMQP";
            }
        });
        Assert.assertEquals((Object)"AMQP", (Object)TransportFactory.getConnectorName());
        ServerAddress addr = new ServerAddress(Schema.IGNORE);
        TestQpidServer server = new TestQpidServer(addr);
        server.start();
        AbstractTransportConnectorTest.doTest((ServerAddress)addr, ProductJsonSerializer.class, (AbstractTransportConnectorTest.TransportParameterConfigurer)configurer);
        AbstractTransportConnectorTest.doTest((ServerAddress)addr, ProductProtobufSerializer.class, (AbstractTransportConnectorTest.TransportParameterConfigurer)configurer);
        server.stop(true);
        TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)old);
    }

    private static class FakeAuthConnector
    extends RabbitMqAmqpTransportConnector {
        private FakeAuthConnector() {
        }

        protected void configureFactory(ConnectionFactory factory) {
            factory.setUsername("user");
            factory.setPassword("pwd");
        }
    }
}

