/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.mqttv3;

import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.basics.AbstractMqttTransportConnector;
import de.iip_ecosphere.platform.transport.connectors.basics.MqttQoS;
import java.io.IOException;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.LoggerFactory;

public class PahoMqttV3TransportConnector
extends AbstractMqttTransportConnector {
    public static final String NAME = "MQTT v3";
    private MqttAsyncClient client;
    private boolean tlsEnabled = false;
    private int qos = MqttQoS.AT_LEAST_ONCE.value();

    public void connect(TransportParameter params) throws IOException {
        super.connect(params);
        this.qos = params.getMqttQoS().value();
        try {
            Object broker = this.useTls(params) ? "ssl://" : "tcp://";
            broker = (String)broker + params.getHost() + ":" + params.getPort();
            this.client = new MqttAsyncClient((String)broker, this.getApplicationId(), (MqttClientPersistence)new MemoryPersistence());
            this.client.setCallback((MqttCallback)new Callback());
            MqttConnectOptions connOpts = new MqttConnectOptions();
            connOpts.setCleanSession(false);
            connOpts.setKeepAliveInterval(params.getKeepAlive());
            connOpts.setAutomaticReconnect(true);
            connOpts.setMaxInflight(1000);
            if (this.useTls(params)) {
                try {
                    connOpts.setSocketFactory((SocketFactory)this.createTlsContext(params).getSocketFactory());
                    connOpts.setHttpsHostnameVerificationEnabled(params.getHostnameVerification());
                    this.tlsEnabled = true;
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("MQTT: Loading keystore " + e.getMessage() + ". Trying with no TLS.");
                }
            }
            this.waitForCompletion(this.client.connect(connOpts));
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("MQTT: connected");
        }
        catch (MqttException e) {
            throw new IOException(e);
        }
    }

    public void setReceptionCallback(String stream, ReceptionCallback<?> callback) throws IOException {
        super.setReceptionCallback(stream, callback);
        try {
            this.waitForCompletion(this.client.subscribe(stream, MqttQoS.AT_LEAST_ONCE.value()));
        }
        catch (MqttException e) {
            throw new IOException(e);
        }
    }

    public void unsubscribe(String stream, boolean delete) throws IOException {
        super.unsubscribe(stream, delete);
        try {
            this.waitForCompletion(this.client.unsubscribe(stream));
        }
        catch (MqttException e) {
            throw new IOException(e);
        }
    }

    public void disconnect() throws IOException {
        super.disconnect();
        try {
            this.waitForCompletion(this.client.disconnect());
            this.client.close();
        }
        catch (MqttException e) {
            throw new IOException(e);
        }
    }

    public void asyncSend(String stream, Object data) throws IOException {
        this.send(stream, data, false);
    }

    public void syncSend(String stream, Object data) throws IOException {
        this.send(stream, data, true);
    }

    private void send(String stream, Object data, boolean block) throws IOException {
        byte[] payload = this.serialize(stream, data);
        MqttMessage message = new MqttMessage(payload);
        message.setQos(this.qos);
        try {
            IMqttDeliveryToken token = this.client.publish(stream, message);
            if (block) {
                this.waitForCompletion((IMqttToken)token);
            }
        }
        catch (MqttException e) {
            throw new IOException(e);
        }
    }

    private void waitForCompletion(IMqttToken token) throws MqttException {
        token.waitForCompletion((long)this.getActionTimeout());
    }

    public String getName() {
        return NAME;
    }

    public String supportedEncryption() {
        return "TLS";
    }

    public String enabledEncryption() {
        return this.tlsEnabled ? "TLS" : null;
    }

    private class Callback
    implements MqttCallback {
        private Callback() {
        }

        public void connectionLost(Throwable cause) {
        }

        public void messageArrived(String topic, MqttMessage message) throws Exception {
            PahoMqttV3TransportConnector.this.notifyCallback(topic, message.getPayload());
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }
    }
}

