/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.mqttv5;

import de.iip_ecosphere.platform.transport.connectors.basics.MqttQoS;
import de.iip_ecosphere.platform.transport.connectors.impl.AbstractTransportConnector;
import de.iip_ecosphere.platform.transport.spring.binder.mqttv5.MqttConfiguration;
import de.iip_ecosphere.platform.transport.spring.binder.mqttv5.MqttV5MessageBinder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttV5MessageBinder.class);
    private static MqttAsyncClient client;
    private static MqttConfiguration configuration;
    private static Callback callback;
    private static MqttQoS qos;

    static {
        qos = MqttQoS.AT_LEAST_ONCE;
    }

    static synchronized void createClient(MqttConfiguration config) {
        if (client == null) {
            try {
                configuration = config;
                qos = config.getQos();
                String clientId = AbstractTransportConnector.getApplicationId((String)config.getClientId(), (String)"stream", (boolean)config.getAutoClientId());
                LOGGER.info("Connecting to " + config.getBrokerString() + " with client id " + clientId);
                MqttAsyncClient cl = new MqttAsyncClient(config.getBrokerString(), clientId, (MqttClientPersistence)new MemoryPersistence());
                callback = new Callback();
                cl.setCallback((MqttCallback)callback);
                MqttConnectionOptions connOpts = new MqttConnectionOptions();
                connOpts.setCleanStart(false);
                connOpts.setKeepAliveInterval(config.getKeepAlive());
                connOpts.setAutomaticReconnect(true);
                MqttClient.waitForCompletion(cl.connect(connOpts));
                client = cl;
            }
            catch (MqttException e) {
                LOGGER.error("Connecting MQTT client: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void stopClient() {
        try {
            MqttClient.waitForCompletion(client.disconnect());
            client.close();
            callback = null;
            client = null;
        }
        catch (MqttException e) {
            LOGGER.error("Stopping MQTT client: " + e.getMessage(), (Throwable)e);
        }
    }

    static boolean subscribeTo(String topic, ArrivedCallback arrivedCallback) {
        boolean done = false;
        if (!configuration.isFilteredTopic(topic) && client != null) {
            try {
                callback.callbacks.put(topic, arrivedCallback);
                MqttClient.waitForCompletion(client.subscribe(topic, MqttQoS.AT_LEAST_ONCE.value()));
                LOGGER.info("Subscribed to " + topic);
                done = true;
            }
            catch (MqttException e) {
                LOGGER.error("Subscribing to MQTT topic '" + topic + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return done;
    }

    static boolean unsubscribeFrom(String topic) {
        boolean done = false;
        if (!configuration.isFilteredTopic(topic) && client != null) {
            try {
                callback.callbacks.remove(topic);
                MqttClient.waitForCompletion(client.unsubscribe(topic));
                LOGGER.info("Unsubscribed from " + topic);
                done = true;
            }
            catch (MqttException e) {
                LOGGER.error("Unsubscribing from MQTT topic '" + topic + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return done;
    }

    static void send(String topic, byte[] payload) {
        if (client != null) {
            MqttMessage message = new MqttMessage(payload);
            message.setQos(qos.value());
            try {
                client.publish(topic, message);
            }
            catch (MqttException e) {
                LOGGER.error("Sending MQTT message with topic " + topic + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    static void waitForCompletion(IMqttToken token) throws MqttException {
        token.waitForCompletion((long)configuration.getActionTimeout());
    }

    public static interface ArrivedCallback {
        public void messageArrived(String var1, MqttMessage var2);
    }

    private static class Callback
    implements MqttCallback {
        private Map<String, ArrivedCallback> callbacks = Collections.synchronizedMap(new HashMap());

        private Callback() {
        }

        public void messageArrived(String topic, MqttMessage message) throws Exception {
            ArrivedCallback cb = this.callbacks.get(topic);
            if (cb != null) {
                cb.messageArrived(topic, message);
            }
        }

        public void disconnected(MqttDisconnectResponse disconnectResponse) {
            LOGGER.info("Disconnected: " + disconnectResponse.getReasonString());
        }

        public void mqttErrorOccurred(MqttException exception) {
        }

        public void deliveryComplete(IMqttToken token) {
        }

        public void connectComplete(boolean reconnect, String serverURI) {
            LOGGER.info("Connection complete reconnect: " + reconnect + " on " + serverURI);
        }

        public void authPacketArrived(int reasonCode, MqttProperties properties) {
        }
    }
}

