/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.mqttv5;

import de.iip_ecosphere.platform.transport.connectors.basics.MqttQoS;
import de.iip_ecosphere.platform.transport.connectors.impl.AbstractTransportConnector;
import de.iip_ecosphere.platform.transport.spring.binder.mqttv5.MqttConfiguration;
import de.iip_ecosphere.platform.transport.spring.binder.mqttv5.MqttV5MessageBinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MqttClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttV5MessageBinder.class);
    private static MqttClient lastInstance;
    private MqttAsyncClient client;
    private MqttConfiguration configuration;
    private Callback callback;
    private MqttQoS qos = MqttQoS.AT_LEAST_ONCE;

    public MqttClient() {
        lastInstance = this;
    }

    public static MqttClient getLastInstance() {
        return lastInstance;
    }

    public MqttConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized void createClient(MqttConfiguration config) {
        if (null == this.client) {
            try {
                this.configuration = config;
                this.qos = config.getQos();
                String clientId = AbstractTransportConnector.getApplicationId((String)config.getClientId(), (String)"stream", (boolean)config.getAutoClientId());
                LOGGER.info("Connecting to " + config.getBrokerString() + " with client id " + clientId);
                MqttAsyncClient cl = new MqttAsyncClient(config.getBrokerString(), clientId, (MqttClientPersistence)new MemoryPersistence());
                this.callback = new Callback();
                cl.setCallback((MqttCallback)this.callback);
                MqttConnectionOptions connOpts = new MqttConnectionOptions();
                connOpts.getConnectionProperties().setReceiveMaximum(null);
                connOpts.setCleanStart(false);
                connOpts.setKeepAliveInterval(config.getKeepAlive());
                connOpts.setAutomaticReconnect(true);
                if (config.useTls()) {
                    try {
                        connOpts.setHttpsHostnameVerificationEnabled(config.getHostnameVerification());
                        connOpts.setSocketFactory((SocketFactory)config.createTlsContext().getSocketFactory());
                    }
                    catch (IOException e) {
                        LOGGER.error("TLS setup failed " + e.getMessage() + ". Trying plaintext.");
                    }
                }
                this.waitForCompletion(cl.connect(connOpts));
                this.client = cl;
            }
            catch (MqttException e) {
                LOGGER.error("Connecting MQTT client: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stopClient() {
        ArrayList<String> channels = new ArrayList<String>(this.callback.callbacks.keySet());
        for (String channel : channels) {
            this.unsubscribeFrom(channel);
        }
        try {
            this.waitForCompletion(this.client.disconnect());
            this.client.close();
            this.callback = null;
            this.client = null;
        }
        catch (MqttException e) {
            LOGGER.error("Stopping MQTT client: " + e.getMessage(), (Throwable)e);
        }
    }

    boolean subscribeTo(String topic, ArrivedCallback arrivedCallback) {
        boolean done = false;
        if (!this.configuration.isFilteredTopic(topic) && null != this.client) {
            try {
                this.callback.callbacks.put(topic, arrivedCallback);
                this.waitForCompletion(this.client.subscribe(topic, MqttQoS.AT_LEAST_ONCE.value()));
                LOGGER.info("Subscribed to " + topic);
                done = true;
            }
            catch (MqttException e) {
                LOGGER.error("Subscribing to MQTT topic '" + topic + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return done;
    }

    boolean unsubscribeFrom(String topic) {
        boolean done = false;
        if (!this.configuration.isFilteredTopic(topic) && null != this.client) {
            try {
                this.callback.callbacks.remove(topic);
                this.waitForCompletion(this.client.unsubscribe(topic));
                LOGGER.info("Unsubscribed from " + topic);
                done = true;
            }
            catch (MqttException e) {
                LOGGER.error("Unsubscribing from MQTT topic '" + topic + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return done;
    }

    void send(String topic, byte[] payload) {
        if (null != this.client) {
            MqttMessage message = new MqttMessage(payload);
            message.setQos(this.qos.value());
            try {
                this.client.publish(topic, message);
            }
            catch (MqttException e) {
                LOGGER.error("Sending MQTT message with topic " + topic + ": " + e.getMessage());
            }
        }
    }

    void waitForCompletion(IMqttToken token) throws MqttException {
        token.waitForCompletion((long)this.configuration.getActionTimeout());
    }

    private static class Callback
    implements MqttCallback {
        private Map<String, ArrivedCallback> callbacks = Collections.synchronizedMap(new HashMap());

        private Callback() {
        }

        public void messageArrived(String topic, MqttMessage message) throws Exception {
            ArrivedCallback cb = this.callbacks.get(topic);
            if (null != cb) {
                cb.messageArrived(topic, message);
            }
        }

        public void disconnected(MqttDisconnectResponse disconnectResponse) {
            LOGGER.info("Disconnected: " + disconnectResponse.getReasonString());
        }

        public void mqttErrorOccurred(MqttException exception) {
        }

        public void deliveryComplete(IMqttToken token) {
        }

        public void connectComplete(boolean reconnect, String serverURI) {
            LOGGER.info("Connection complete reconnect: " + reconnect + " on " + serverURI);
        }

        public void authPacketArrived(int reasonCode, MqttProperties properties) {
        }
    }

    public static interface ArrivedCallback {
        public void messageArrived(String var1, MqttMessage var2);
    }
}

