/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.support.function.IOConsumer;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import de.iip_ecosphere.platform.transport.status.Alert;
import de.iip_ecosphere.platform.transport.status.ComponentTypes;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import java.io.IOException;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public class Transport {
    private static Predicate<TraceRecord> traceFilter;
    private static TransportInstance globalTransport;
    private static TransportInstance localTransport;
    private static Set<String> globalRoutingKeys;
    private static final boolean DEBUG = false;

    private Transport() {
    }

    public static void sendServiceStatus(ActionType action, String serviceId, String ... aliasIds) {
        globalTransport.sendServiceStatus(action, serviceId, aliasIds);
    }

    public static void sendServiceArtifactStatus(ActionType action, String artifactId, String ... aliasIds) {
        globalTransport.sendServiceArtifactStatus(action, artifactId, aliasIds);
    }

    public static void sendContainerStatus(ActionType action, String containerId, String ... aliasIds) {
        globalTransport.sendContainerStatus(action, containerId, aliasIds);
    }

    public static void sendResourceStatus(ActionType action, String ... aliasIds) {
        globalTransport.sendResourceStatus(action, aliasIds);
    }

    public static void sendResourceStatus(ActionType action, String deviceId, String ... aliasIds) {
        globalTransport.sendResourceStatus(action, deviceId, aliasIds);
    }

    public static void send(IOConsumer<TransportConnector> sender, String kind) {
        globalTransport.send(sender, kind);
    }

    public static void send(IOConsumer<TransportConnector> sender, String kind, String ... routingKeys) {
        if (globalTransport == localTransport) {
            globalTransport.send(sender, kind);
        } else {
            boolean global = false;
            boolean local = false;
            if (null == routingKeys || routingKeys.length == 0) {
                global = true;
            } else {
                for (int k = 0; k < routingKeys.length; ++k) {
                    if (globalRoutingKeys.contains(routingKeys[k])) {
                        global = true;
                        continue;
                    }
                    local = true;
                }
            }
            if (global) {
                globalTransport.send(sender, kind);
            }
            if (local) {
                localTransport.send(sender, kind);
            }
        }
    }

    public static TransportConnector createConnector(String routingKey) {
        TransportInstance result = globalTransport == localTransport ? globalTransport : (null == routingKey || routingKey.length() == 0 ? globalTransport : (globalRoutingKeys.contains(routingKey) ? globalTransport : localTransport));
        return result.createConnector();
    }

    private static final String getHostSafe(TransportInstance instance) {
        TransportSetup setup;
        Supplier supplier = instance.transportSupplier;
        String result = null != supplier ? (null != (setup = (TransportSetup)supplier.get()) ? setup.getHost() + ":" + setup.getPort() : "<no setup>") : "<no supplier>";
        return result;
    }

    public static void addGlobalRoutingKey(String routingKey) {
        if (null != routingKey && routingKey.length() > 0) {
            globalRoutingKeys.add(routingKey);
        }
    }

    public static void setTraceFilter(Predicate<TraceRecord> filter) {
        traceFilter = filter;
    }

    public static void sendTraceRecord(TraceRecord record) {
        globalTransport.sendTraceRecord(record);
    }

    public static void sendProcessStatus(String componentId, int step, int max, String description) {
        globalTransport.sendProcessStatus(componentId, step, max, description);
    }

    public static void sendProcessStatus(String componentId, int step, int max, String description, String subDescription) {
        globalTransport.sendProcessStatus(componentId, step, max, description, subDescription);
    }

    public static void sendStatus(StatusMessage msg) {
        globalTransport.sendStatus(msg);
    }

    public static void sendAlert(Alert alert) {
        globalTransport.sendAlert(alert);
    }

    public static void setTransportSetup(Supplier<TransportSetup> supplier) {
        globalTransport.setTransportSetup(supplier);
    }

    public static void setLocalSetup(Supplier<TransportSetup> supplier) {
        if (localTransport == globalTransport) {
            localTransport = new TransportInstance();
        }
        localTransport.setTransportSetup(supplier);
    }

    public static TransportConnector createConnector() {
        return globalTransport.createConnector();
    }

    public static void releaseConnector() {
        globalTransport.releaseConnector();
    }

    public static void releaseConnector(boolean stayOff) {
        globalTransport.releaseConnector(stayOff);
    }

    public static TransportConnector getConnector() {
        return globalTransport.getConnector();
    }

    public static TransportInstance getGlobalTransport() {
        return globalTransport;
    }

    public static TransportConnector getLocalConnector() {
        return localTransport.getConnector();
    }

    public static TransportInstance getLocalTransport() {
        return localTransport;
    }

    static {
        localTransport = globalTransport = new TransportInstance();
        globalRoutingKeys = new HashSet<String>();
    }

    public static class TransportInstance {
        private TransportConnector connector;
        private boolean stayOffline = false;
        private Queue<IOConsumer<TransportConnector>> queue = new ConcurrentLinkedDeque<IOConsumer<TransportConnector>>();
        private Supplier<TransportSetup> transportSupplier;

        public TransportInstance() {
        }

        public TransportInstance(Supplier<TransportSetup> supplier) {
            this.setTransportSetup(supplier);
        }

        public void setTransportSetup(Supplier<TransportSetup> supplier) {
            this.transportSupplier = supplier;
        }

        public void sendServiceStatus(ActionType action, String serviceId, String ... aliasIds) {
            this.sendStatus(new StatusMessage(ComponentTypes.SERVICE, action, serviceId, Id.getDeviceId(), aliasIds));
        }

        public void sendServiceArtifactStatus(ActionType action, String artifactId, String ... aliasIds) {
            this.sendStatus(new StatusMessage(ComponentTypes.SERVICE_ARTIFACT, action, artifactId, Id.getDeviceId(), aliasIds));
        }

        public void sendContainerStatus(ActionType action, String containerId, String ... aliasIds) {
            this.sendStatus(new StatusMessage(ComponentTypes.CONTAINER, action, containerId, Id.getDeviceId(), aliasIds));
        }

        public void sendResourceStatus(ActionType action, String ... aliasIds) {
            this.sendResourceStatus(action, (String)null, aliasIds);
        }

        public void sendResourceStatus(ActionType action, String deviceId, String ... aliasIds) {
            this.sendStatus(new StatusMessage(action, null == deviceId ? Id.getDeviceId() : deviceId, aliasIds));
        }

        public void send(IOConsumer<TransportConnector> sender, String kind) {
            this.createConnector();
            if (null != this.connector) {
                try {
                    sender.accept((Object)this.connector);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(Transport.class).error("Cannot sent {} message: {}", (Object)kind, (Object)e.getMessage());
                }
                catch (NullPointerException e) {
                    LoggerFactory.getLogger(Transport.class).error("Cannot sent {} message: Connector not yet connected (NPE)");
                }
            } else {
                this.queue.add(sender);
                LoggerFactory.getLogger(Transport.class).error("Cannot sent {} message now. Queued message until connector becomes available.", (Object)kind);
            }
        }

        public void setTraceFilter(Predicate<TraceRecord> filter) {
            traceFilter = filter;
        }

        public void sendTraceRecord(TraceRecord record) {
            if (null == traceFilter || traceFilter.test(record)) {
                this.send((IOConsumer<TransportConnector>)((IOConsumer)c -> record.send((TransportConnector)c)), "trace");
            }
        }

        public void sendProcessStatus(String componentId, int step, int max, String description) {
            this.sendProcessStatus(componentId, step, max, description, null);
        }

        public void sendProcessStatus(String componentId, int step, int max, String description, String subDescription) {
            StatusMessage msg = new StatusMessage(ActionTypes.PROCESS, componentId, Id.getDeviceId()).withDescription(description).withSubDescription(subDescription);
            this.send((IOConsumer<TransportConnector>)((IOConsumer)c -> msg.send((TransportConnector)c)), "progress status");
        }

        public void sendStatus(StatusMessage msg) {
            this.send((IOConsumer<TransportConnector>)((IOConsumer)c -> msg.send((TransportConnector)c)), "status");
        }

        public void sendAlert(Alert alert) {
            this.send((IOConsumer<TransportConnector>)((IOConsumer)c -> alert.send((TransportConnector)c)), "alert");
        }

        public TransportConnector createConnector() {
            if (null == this.connector && !this.stayOffline && null != this.transportSupplier) {
                TransportParameter params = this.transportSupplier.get().createParameter();
                try {
                    TransportConnector con = TransportFactory.createConnector();
                    con.connect(params);
                    this.connector = con;
                    if (!this.queue.isEmpty()) {
                        new Thread(() -> {
                            while (this.queue.isEmpty()) {
                                try {
                                    this.queue.remove().accept((Object)this.connector);
                                }
                                catch (IOException e) {
                                    LoggerFactory.getLogger(Transport.class).error("Cannot sent deferred status message: " + e.getMessage() + ". Dropping.");
                                }
                            }
                        }).start();
                    }
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(Transport.class).error("Cannot create transport connector: " + e.getMessage());
                    this.connector = null;
                }
            }
            return this.connector;
        }

        public void releaseConnector() {
            this.releaseConnector(true);
        }

        public void releaseConnector(boolean stayOff) {
            if (null != this.connector) {
                try {
                    this.connector.disconnect();
                    this.connector = null;
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(Transport.class).error("Cannot disconnect transport connector: " + e.getMessage());
                }
            }
            this.stayOffline = stayOff;
            if (this.stayOffline) {
                LoggerFactory.getLogger(Transport.class).error("Staying offline with status/monitoring messages from now on");
            }
        }

        public TransportConnector getConnector() {
            return this.connector;
        }
    }
}

