/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.connectors.impl;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransportConnector
implements TransportConnector {
    private Map<String, List<ReceptionCallback<?>>> callbacks = Collections.synchronizedMap(new HashMap());
    private TransportParameter params;

    public static String getKeystorePassword(TransportParameter params) {
        return AbstractTransportConnector.getKeystorePassword(params.getKeystorePassword());
    }

    public static String getKeystorePassword(String keystorePassword) {
        String keyPasswd = keystorePassword;
        IdentityToken tok = IdentityStore.getInstance().getToken(keystorePassword, new String[0]);
        if (tok != null) {
            if (IdentityToken.TokenType.USERNAME == tok.getType()) {
                keyPasswd = tok.getTokenDataAsString();
            } else {
                LoggerFactory.getLogger(AbstractTransportConnector.class).info("Cannot handle identity token type {}. Using plaintext keystore password as fallback.", (Object)tok.getType());
            }
        }
        return keyPasswd;
    }

    public static boolean applyAuthenticationKey(String authenticationKey, AuthenticationConsumer consumer) {
        boolean authDone = false;
        if (null != authenticationKey) {
            IdentityToken tok = IdentityStore.getInstance().getToken(authenticationKey, new String[0]);
            if (tok != null) {
                if (IdentityToken.TokenType.USERNAME == tok.getType()) {
                    authDone = consumer.accept(tok.getUserName(), tok.getTokenDataAsString(), tok.getTokenEncryptionAlgorithm());
                } else {
                    LoggerFactory.getLogger(AbstractTransportConnector.class).info("Cannot handle identity token type {}. Trying user/password.", (Object)tok.getType());
                }
            } else {
                LoggerFactory.getLogger(AbstractTransportConnector.class).info("Authentication key {} not found. Trying user/password.", (Object)authenticationKey);
            }
        }
        return authDone;
    }

    @Override
    public void setReceptionCallback(String stream, ReceptionCallback<?> callback) throws IOException {
        List<ReceptionCallback<Object>> l = this.callbacks.get(stream);
        if (null == l) {
            l = Collections.synchronizedList(new ArrayList());
            this.callbacks.put(stream, l);
        }
        l.add(callback);
    }

    @Override
    public void detachReceptionCallback(String stream, ReceptionCallback<?> callback) throws IOException {
        boolean removed;
        List<ReceptionCallback<?>> l = this.callbacks.get(stream);
        if (l != null && (removed = l.remove(callback)) && l.isEmpty()) {
            this.callbacks.remove(stream);
            this.unsubscribe(stream, true);
        }
    }

    @Override
    public void connect(TransportParameter params) throws IOException {
        this.params = params;
    }

    @Override
    public void unsubscribe(String stream, boolean delete) throws IOException {
        this.callbacks.remove(stream);
    }

    @Override
    public void disconnect() throws IOException {
        if (this.getCloseAction().doClose()) {
            ArrayList<String> streams = new ArrayList<String>(this.callbacks.keySet());
            for (String stream : streams) {
                try {
                    this.unsubscribe(stream, this.getCloseAction().doDelete());
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("While disconnecting/unsubscribing '" + stream + "': " + e.getMessage());
                }
            }
        }
    }

    protected TransportParameter getTransportParameter() {
        return this.params;
    }

    protected int getActionTimeout() {
        return this.params.getActionTimeout();
    }

    protected TransportParameter.CloseAction getCloseAction() {
        return this.params.getCloseAction();
    }

    protected String getApplicationId() {
        return AbstractTransportConnector.getApplicationId(this.params.getApplicationId(), "tp", this.params.getAutoApplicationId());
    }

    public static String getApplicationId(String applicationId, String infix, boolean makeUnique) {
        String separator = "-";
        String appId = applicationId;
        if (null == appId) {
            appId = "";
        }
        if (null == infix) {
            infix = "";
        }
        if (infix.length() > 0) {
            if (appId.length() > 0) {
                appId = appId + "-";
            }
            if (!(appId = appId + infix).endsWith("-") && makeUnique) {
                appId = appId + "-";
            }
        }
        if (makeUnique) {
            appId = appId + NetUtils.getOwnIP() + "-" + System.currentTimeMillis();
        }
        return appId;
    }

    protected List<ReceptionCallback<?>> getCallback(String stream) {
        return this.callbacks.get(stream);
    }

    protected void registerStream(String stream) {
        if (!this.isStreamKnown(stream)) {
            this.callbacks.put(stream, null);
        }
    }

    protected boolean isStreamKnown(String stream) {
        return this.callbacks.containsKey(stream);
    }

    protected <T> void notifyCallback(String stream, byte[] data) {
        List<ReceptionCallback<?>> callbacks = this.getCallback(stream);
        if (null != callbacks) {
            for (int c = 0; c < callbacks.size(); ++c) {
                ReceptionCallback<?> callback = callbacks.get(c);
                Serializer<?> serializer = SerializerRegistry.getSerializer(callback.getType());
                if (null != serializer) {
                    try {
                        callback.received(serializer.from(data));
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Cannot deserialize: {}", (Object)e.getMessage());
                    }
                    continue;
                }
                LoggerFactory.getLogger(this.getClass()).warn("No serializer registered for {}", (Object)callback.getType().getName());
            }
        }
    }

    protected <T> byte[] serialize(String stream, T data) throws IOException {
        Class<?> cls = data.getClass();
        Serializer<?> serializer = SerializerRegistry.getSerializer(cls);
        byte[] result = null != serializer ? (byte[])serializer.to(data) : new byte[]{};
        return result;
    }

    public static interface AuthenticationConsumer {
        public boolean accept(String var1, String var2, String var3);
    }
}

