/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.serialization;

import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.StringSerializer;
import de.iip_ecosphere.platform.transport.status.AlertSerializer;
import de.iip_ecosphere.platform.transport.status.StatusMessageSerializer;
import de.iip_ecosphere.platform.transport.status.TraceRecordSerializer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SerializerRegistry {
    private static Map<Class<?>, Serializer<?>> serializers = Collections.synchronizedMap(new HashMap());
    private static String wireName = "";

    public static void resetDefaults() {
        SerializerRegistry.registerSerializer(StringSerializer.class);
        SerializerRegistry.registerSerializer(StatusMessageSerializer.class);
        SerializerRegistry.registerSerializer(TraceRecordSerializer.class);
        SerializerRegistry.registerSerializer(AlertSerializer.class);
    }

    public static <T> Serializer<T> getSerializer(Class<T> type) {
        return serializers.get(type);
    }

    public static boolean hasSerializer(Class<?> type) {
        return serializers.get(type) != null;
    }

    public static <T> void registerSerializer(Class<? extends Serializer<T>> type) throws IllegalArgumentException {
        try {
            SerializerRegistry.registerSerializer(type.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> void registerSerializer(Serializer<T> serializer) {
        serializers.put(serializer.getType(), serializer);
    }

    public static void unregisterSerializer(Serializer<?> serializer) {
        SerializerRegistry.unregisterSerializer(serializer.getType());
    }

    public static void unregisterSerializer(Class<?> type) {
        serializers.remove(type);
    }

    public static String getName() {
        return wireName;
    }

    public static String setName(String name) {
        String old = name;
        wireName = name;
        return old;
    }

    static {
        SerializerRegistry.resetDefaults();
    }
}

