/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.serialization;

import de.iip_ecosphere.platform.support.ClassLoaderUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.LoggerFactory;

public class TypeTranslators {
    public static final TypeTranslator<String, String> STRING = new TypeTranslator<String, String>(){

        @Override
        public String from(String data) throws IOException {
            return data;
        }

        @Override
        public String to(String source) throws IOException {
            return source;
        }
    };
    public static final TypeTranslator<String, String> JSON_STRING = new TypeTranslator<String, String>(){

        @Override
        public String from(String data) throws IOException {
            return StringEscapeUtils.escapeJson((String)data);
        }

        @Override
        public String to(String source) throws IOException {
            return StringEscapeUtils.unescapeJson((String)source);
        }
    };
    public static final TypeTranslator<String, Integer> INTEGER = new TypeTranslator<String, Integer>(){

        @Override
        public String from(Integer data) throws IOException {
            return data.toString();
        }

        @Override
        public Integer to(String source) throws IOException {
            try {
                return Integer.parseInt(source);
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
    };
    public static final TypeTranslator<String, Long> LONG = new TypeTranslator<String, Long>(){

        @Override
        public String from(Long data) throws IOException {
            return data.toString();
        }

        @Override
        public Long to(String source) throws IOException {
            try {
                return Long.parseLong(source);
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
    };
    public static final TypeTranslator<String, Boolean> BOOLEAN = new TypeTranslator<String, Boolean>(){

        @Override
        public String from(Boolean data) throws IOException {
            return data.toString();
        }

        @Override
        public Boolean to(String source) throws IOException {
            return Boolean.valueOf(source);
        }
    };
    public static final TypeTranslator<String, Double> DOUBLE = new TypeTranslator<String, Double>(){

        @Override
        public String from(Double data) throws IOException {
            return data.toString();
        }

        @Override
        public Double to(String source) throws IOException {
            try {
                return Double.parseDouble(source);
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
    };

    public static TypeTranslator<?, ?> createTypeTranslator(ClassLoader loader, String className) {
        TypeTranslator result = null;
        try {
            Class<?> translatorClass = loader.loadClass(className);
            result = (TypeTranslator)translatorClass.newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            String loaders = ClassLoaderUtils.hierarchyToString((ClassLoader)loader);
            LoggerFactory.getLogger(TypeTranslators.class).error("Cannot instantiate instance of type '" + className + " via " + loaders + "': " + e.getClass().getSimpleName() + " " + e.getMessage());
        }
        return result;
    }

    public static Serializer<?> createSerializer(ClassLoader loader, String className) {
        return (Serializer)TypeTranslators.createTypeTranslator(loader, className);
    }
}

