/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.status;

import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ComponentType;
import de.iip_ecosphere.platform.transport.status.ComponentTypes;
import java.io.IOException;

public class StatusMessage {
    public static final String STATUS_STREAM = "ComponentStatus";
    private ComponentType componentType;
    private ActionType action;
    private String id;
    private String[] aliasIds;
    private String deviceId;
    private int progress = -1;
    private String description = "";
    private String subDescription = "";

    StatusMessage() {
    }

    public StatusMessage(ActionType action, String id, String ... aliasIds) {
        this(ComponentTypes.DEVICE, action, id, id, aliasIds);
    }

    public StatusMessage(ComponentType componentType, ActionType action, String id, String deviceId, String ... aliasIds) {
        this.componentType = componentType;
        this.action = action;
        this.id = id;
        this.deviceId = deviceId;
        this.aliasIds = aliasIds;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    void setComponentType(ComponentType componentType) {
        this.componentType = componentType;
    }

    public ActionType getAction() {
        return this.action;
    }

    void setAction(ActionType action) {
        this.action = action;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String[] getAliasIds() {
        return this.aliasIds;
    }

    void setAliasIds(String[] aliasIds) {
        this.aliasIds = aliasIds;
    }

    public void send(TransportConnector conn) throws IOException {
        conn.asyncSend(STATUS_STREAM, this);
    }

    public StatusMessage withProgress(int progress) {
        this.progress = progress;
        return this;
    }

    public int getProgress() {
        return this.progress;
    }

    public StatusMessage withDescription(String description) {
        this.description = null == description ? "" : description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public StatusMessage withSubDescription(String subDescription) {
        this.subDescription = null == subDescription ? "" : subDescription;
        return this;
    }

    public String getSubDescription() {
        return this.subDescription;
    }
}

