/*
 * Decompiled with CFR 0.152.
 */
package de.innus.util.parser.bundesbank;

import de.innus.util.parser.bundesbank.DailyReconciliationBody;
import de.innus.util.parser.bundesbank.DailyReconciliationHeader;
import de.innus.util.parser.bundesbank.DailyReconciliationTrailer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class DailyReconciliationParser {
    private static final Charset EBCDIC_CODE_PAGE = Charset.forName("Cp1047");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyMMddHHmmss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyMMdd");
    private final AtomicInteger currentPosition = new AtomicInteger(0);
    private final BufferedInputStream inputStream;
    private final Integer actualSize;

    private DailyReconciliationParser(BufferedInputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.actualSize = this.inputStream.available();
    }

    public static DailyReconciliationParser create(BufferedInputStream inputStream) throws IOException {
        return new DailyReconciliationParser(inputStream);
    }

    public Optional<DailyReconciliationHeader> header() throws IOException {
        DailyReconciliationHeader.RecordType recordType;
        if (this.currentPosition.get() > 0) {
            return Optional.empty();
        }
        byte[] recordTypeBytes = new byte[DailyReconciliationHeader.RECORD_TYPE_LENGTH.intValue()];
        this.inputStream.read(recordTypeBytes, 0, recordTypeBytes.length);
        try {
            recordType = DailyReconciliationHeader.RecordType.valueOf(new String(recordTypeBytes, EBCDIC_CODE_PAGE));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
        DailyReconciliationHeader header = new DailyReconciliationHeader();
        header.setRecordType(recordType);
        byte[] headerBytes = new byte[recordType.length() - DailyReconciliationHeader.RECORD_TYPE_LENGTH];
        this.inputStream.read(headerBytes, 0, headerBytes.length);
        AtomicInteger headerPosition = new AtomicInteger(0);
        header.setServiceIdentifier(new String(headerBytes, headerPosition.get(), (int)DailyReconciliationHeader.SERVICE_IDENTIFIER_LENGTH, EBCDIC_CODE_PAGE));
        header.setFileType(new String(headerBytes, headerPosition.addAndGet(DailyReconciliationHeader.SERVICE_IDENTIFIER_LENGTH), (int)DailyReconciliationHeader.FILE_TYPE_LENGTH, EBCDIC_CODE_PAGE));
        header.setSendingInstitution(new String(headerBytes, headerPosition.addAndGet(DailyReconciliationHeader.FILE_TYPE_LENGTH), (int)DailyReconciliationHeader.SENDING_INSTITUTION_LENGTH, EBCDIC_CODE_PAGE));
        header.setFileReference(new String(headerBytes, headerPosition.addAndGet(DailyReconciliationHeader.SENDING_INSTITUTION_LENGTH), (int)DailyReconciliationHeader.FILE_REFERENCE_LENGTH, EBCDIC_CODE_PAGE));
        header.setDateTime(LocalDateTime.from(DATE_TIME_FORMATTER.parse(new String(headerBytes, headerPosition.addAndGet(DailyReconciliationHeader.FILE_REFERENCE_LENGTH), (int)DailyReconciliationHeader.DATE_TIME_LENGTH, EBCDIC_CODE_PAGE))));
        String testCode = new String(headerBytes, headerPosition.addAndGet(DailyReconciliationHeader.DATE_TIME_LENGTH), (int)DailyReconciliationHeader.TEST_CODE_LENGTH, EBCDIC_CODE_PAGE);
        header.setTest(testCode.equalsIgnoreCase("T"));
        header.setReceivingInstitution(new String(headerBytes, headerPosition.addAndGet(DailyReconciliationHeader.TEST_CODE_LENGTH), (int)DailyReconciliationHeader.RECEIVING_INSTITUTION_LENGTH, EBCDIC_CODE_PAGE));
        header.setBusinessDate(LocalDate.from(DATE_FORMATTER.parse(new String(headerBytes, headerPosition.addAndGet(DailyReconciliationHeader.RECEIVING_INSTITUTION_LENGTH), (int)DailyReconciliationHeader.BUSINESS_DATE_LENGTH, EBCDIC_CODE_PAGE))));
        this.currentPosition.addAndGet(header.getRecordType().length());
        return Optional.of(header);
    }

    public Boolean nextBody() {
        return this.currentPosition.get() >= 64 && this.actualSize - this.currentPosition.get() > 10;
    }

    public Optional<DailyReconciliationBody> body() throws IOException {
        DailyReconciliationBody.RecordType recordType;
        if (this.currentPosition.get() < 64 || this.actualSize - this.currentPosition.get() <= 10) {
            return Optional.empty();
        }
        byte[] recordTypeBytes = new byte[DailyReconciliationBody.RECORD_TYPE_LENGTH.intValue()];
        this.inputStream.read(recordTypeBytes, 0, recordTypeBytes.length);
        String temp = new String(recordTypeBytes, EBCDIC_CODE_PAGE);
        try {
            recordType = DailyReconciliationBody.RecordType.valueOf(new String(recordTypeBytes, EBCDIC_CODE_PAGE));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(temp);
        }
        Boolean isSubmission = this.isSubmission(recordType);
        DailyReconciliationBody body = new DailyReconciliationBody();
        body.setRecordType(recordType);
        byte[] bodyBytes = new byte[recordType.length() - DailyReconciliationBody.RECORD_TYPE_LENGTH];
        this.inputStream.read(bodyBytes, 0, bodyBytes.length);
        AtomicInteger bodyPosition = new AtomicInteger(0);
        body.setBulkReference(new String(bodyBytes, bodyPosition.get(), (int)DailyReconciliationBody.BULK_REFERENCE_LENGTH, EBCDIC_CODE_PAGE).trim());
        body.setProcessedOrReceivedItems(Integer.valueOf(new String(bodyBytes, bodyPosition.addAndGet(DailyReconciliationBody.BULK_REFERENCE_LENGTH), (int)DailyReconciliationBody.NUMBER_OF_ITEMS_LENGTH, EBCDIC_CODE_PAGE)));
        if (isSubmission.booleanValue()) {
            body.setRejectedItems(Integer.valueOf(new String(bodyBytes, bodyPosition.addAndGet(DailyReconciliationBody.NUMBER_OF_ITEMS_LENGTH), (int)DailyReconciliationBody.NUMBER_OF_ITEMS_LENGTH, EBCDIC_CODE_PAGE)));
        }
        body.setMonetaryValueProcessedOrReceived(new BigDecimal(new String(bodyBytes, bodyPosition.addAndGet(DailyReconciliationBody.NUMBER_OF_ITEMS_LENGTH), (int)DailyReconciliationBody.VALUE_LENGTH, EBCDIC_CODE_PAGE)));
        if (isSubmission.booleanValue()) {
            body.setMonetaryValueRejected(new BigDecimal(new String(bodyBytes, bodyPosition.addAndGet(DailyReconciliationBody.VALUE_LENGTH), (int)DailyReconciliationBody.VALUE_LENGTH, EBCDIC_CODE_PAGE)));
        }
        body.setCycleNumber(Integer.valueOf(new String(bodyBytes, bodyPosition.addAndGet(DailyReconciliationBody.VALUE_LENGTH), (int)DailyReconciliationBody.CYCLE_NUMBER_LENGTH, EBCDIC_CODE_PAGE)));
        this.currentPosition.addAndGet(body.getRecordType().length());
        return Optional.of(body);
    }

    public Optional<DailyReconciliationTrailer> trailer() throws IOException {
        DailyReconciliationTrailer.RecordType recordType;
        if (this.actualSize - this.currentPosition.get() > 10) {
            return Optional.empty();
        }
        byte[] recordTypeBytes = new byte[DailyReconciliationTrailer.RECORD_TYPE_LENGTH.intValue()];
        this.inputStream.read(recordTypeBytes, 0, recordTypeBytes.length);
        try {
            recordType = DailyReconciliationTrailer.RecordType.valueOf(new String(recordTypeBytes, EBCDIC_CODE_PAGE));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
        DailyReconciliationTrailer trailer = new DailyReconciliationTrailer();
        trailer.setRecordType(recordType);
        byte[] trailerBytes = new byte[recordType.length() - DailyReconciliationTrailer.RECORD_TYPE_LENGTH];
        this.inputStream.read(trailerBytes, 0, trailerBytes.length);
        AtomicInteger trailerPosition = new AtomicInteger(0);
        trailer.setNumberOfRecords(Integer.valueOf(new String(trailerBytes, trailerPosition.get(), (int)DailyReconciliationTrailer.NUMBER_OF_RECORDS_LENGTH, EBCDIC_CODE_PAGE)));
        this.currentPosition.addAndGet(trailer.getRecordType().length());
        return Optional.of(trailer);
    }

    public Optional<String> translate() {
        try {
            byte[] translationBytes = new byte[this.actualSize.intValue()];
            this.inputStream.read(translationBytes, 0, translationBytes.length);
            return Optional.of(new String(translationBytes, EBCDIC_CODE_PAGE));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private Boolean isSubmission(DailyReconciliationBody.RecordType recordType) {
        switch (recordType) {
            case DCSB: 
            case DRIB: 
            case DRSB: 
            case DTSB: {
                return true;
            }
        }
        return false;
    }
}

