/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.validator;

import de.ipb_halle.molecularfaces.validator.Molfile;
import java.io.Reader;
import java.io.StringReader;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.MDLV3000Reader;

public class MolfileValidator
implements ConstraintValidator<Molfile, String> {
    private IChemObjectReader.Mode cdkReaderMode;
    private Molfile.Format format;

    public void initialize(Molfile constraintAnnotation) {
        this.format = constraintAnnotation.format();
        switch (constraintAnnotation.mode()) {
            case RELAXED: {
                this.cdkReaderMode = IChemObjectReader.Mode.RELAXED;
                break;
            }
            default: {
                this.cdkReaderMode = IChemObjectReader.Mode.STRICT;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) return true;
        if (value.isEmpty()) {
            return true;
        }
        if (this.format == Molfile.Format.V2000) {
            try (MDLV2000Reader reader2 = new MDLV2000Reader((Reader)new StringReader(value), this.cdkReaderMode);){
                reader2.read((IChemObject)new AtomContainer());
                boolean bl2 = true;
                return bl2;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.format != Molfile.Format.V3000) return false;
        try (MDLV3000Reader reader = new MDLV3000Reader((Reader)new StringReader(value), this.cdkReaderMode);){
            reader.read((IChemObject)new AtomContainer());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }
}

