/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.converter;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert.FacesConverter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.MDLV3000Reader;
import org.openscience.cdk.io.MDLV3000Writer;

@FacesConverter(value="molecularfaces.MDLV3000Converter")
public class MDLV3000Converter
implements Converter {
    public IAtomContainer getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        IAtomContainer iAtomContainer;
        if (value == null || value.isEmpty()) {
            return null;
        }
        MDLV3000Reader reader = new MDLV3000Reader((Reader)new StringReader(value));
        try {
            iAtomContainer = (IAtomContainer)reader.read((IChemObject)new AtomContainer());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ConverterException(new FacesMessage(e.getMessage()), (Throwable)e);
            }
        }
        reader.close();
        return iAtomContainer;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        if (value == null || !(value instanceof IAtomContainer)) {
            return "";
        }
        IAtomContainer mol = (IAtomContainer)value;
        StringWriter writer = new StringWriter();
        try (MDLV3000Writer molWriter = new MDLV3000Writer((Writer)writer);){
            molWriter.write((IChemObject)mol);
        }
        catch (Exception e) {
            throw new ConverterException(new FacesMessage(e.getMessage()), (Throwable)e);
        }
        return writer.toString();
    }
}

