/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.validator;

import de.ipb_halle.molecularfaces.validator.Molfile;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.Reader;
import java.io.StringReader;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.MDLV3000Reader;

public class MolfileValidator
implements ConstraintValidator<Molfile, String> {
    private IChemObjectReader.Mode cdkReaderMode;
    private Molfile.Format format;

    public void initialize(Molfile constraintAnnotation) {
        this.format = constraintAnnotation.format();
        switch (constraintAnnotation.mode()) {
            case RELAXED: {
                this.cdkReaderMode = IChemObjectReader.Mode.RELAXED;
                break;
            }
            default: {
                this.cdkReaderMode = IChemObjectReader.Mode.STRICT;
            }
        }
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        if (this.format == Molfile.Format.V2000) {
            boolean bl;
            MDLV2000Reader reader = new MDLV2000Reader((Reader)new StringReader(value), this.cdkReaderMode);
            try {
                reader.read((IChemObject)new AtomContainer());
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            reader.close();
            return bl;
        }
        if (this.format == Molfile.Format.V3000) {
            boolean bl;
            MDLV3000Reader reader = new MDLV3000Reader((Reader)new StringReader(value), this.cdkReaderMode);
            try {
                reader.read((IChemObject)new AtomContainer());
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            reader.close();
            return bl;
        }
        return false;
    }
}

