/*
 * Decompiled with CFR 0.152.
 */
package de.irissmann.arachni.client.request;

import de.irissmann.arachni.client.request.HttpParameters;

public class HttpParametersBuilder {
    private Integer requestTimeout;
    private Integer requestRedirectLimit;
    private Integer requestConcurrency;
    private Integer requestQueueSize;
    private Integer responseMaxSize;

    HttpParametersBuilder() {
    }

    public HttpParametersBuilder requestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public HttpParametersBuilder requestRedirectLimit(int requestRedirectLimit) {
        this.requestRedirectLimit = requestRedirectLimit;
        return this;
    }

    public HttpParametersBuilder requestConcurrency(int requestConcurrency) {
        this.requestConcurrency = requestConcurrency;
        return this;
    }

    public HttpParametersBuilder requestQueueSize(int requestQueueSize) {
        this.requestQueueSize = requestQueueSize;
        return this;
    }

    public HttpParametersBuilder responseMaxSize(int responseMaxSize) {
        this.responseMaxSize = responseMaxSize;
        return this;
    }

    public HttpParameters build() {
        HttpParameters parameters = new HttpParameters();
        if (this.requestTimeout != null) {
            parameters.setRequestTimeout(this.requestTimeout);
        }
        if (this.requestRedirectLimit != null) {
            parameters.setRequestRedirectLimit(this.requestRedirectLimit);
        }
        if (this.requestConcurrency != null) {
            parameters.setRequestConcurrency(this.requestConcurrency);
        }
        if (this.requestQueueSize != null) {
            parameters.setRequestQueueSize(this.requestQueueSize);
        }
        if (this.responseMaxSize != null) {
            parameters.setResponseMaxSize(this.responseMaxSize);
        }
        return parameters;
    }
}

