/*
 * Decompiled with CFR 0.152.
 */
package de.irissmann.arachni.client.request;

import de.irissmann.arachni.client.request.Scope;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeBuilder {
    private static final Logger log = LoggerFactory.getLogger(ScopeBuilder.class);
    private Integer pageLimit;
    private List<String> excludePathPatterns;

    public ScopeBuilder pageLimit(int pageLimit) {
        if (pageLimit > 0) {
            this.pageLimit = pageLimit;
        } else {
            log.info("PageLimit is not valid and will not be set.");
        }
        return this;
    }

    public ScopeBuilder addExcludePathPatterns(String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            log.info("ExcludePathPattern is empty and will not be added.");
            return this;
        }
        if (this.excludePathPatterns == null) {
            this.excludePathPatterns = new ArrayList<String>();
        }
        this.excludePathPatterns.add(pattern);
        return this;
    }

    public Scope build() {
        Scope scope = new Scope();
        if (this.pageLimit != null) {
            scope.setPageLimit(this.pageLimit);
        }
        if (this.excludePathPatterns != null) {
            scope.setExcludePathPatterns(this.excludePathPatterns);
        }
        return scope;
    }
}

