/*
 * Decompiled with CFR 0.152.
 */
package de.irissmann.arachni.client.request;

import de.irissmann.arachni.client.request.HttpParameters;
import de.irissmann.arachni.client.request.ScanRequest;
import de.irissmann.arachni.client.request.Scope;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScanRequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(ScanRequestBuilder.class);
    private URL url;
    private Scope scope;
    private HttpParameters requestHttp;
    private List<String> checks;

    public ScanRequestBuilder url(String url) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException exception) {
            log.info(exception.getMessage(), (Throwable)exception);
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
        return this;
    }

    public ScanRequestBuilder scope(Scope scope) {
        this.scope = scope;
        return this;
    }

    public ScanRequestBuilder http(HttpParameters requestHttp) {
        this.requestHttp = requestHttp;
        return this;
    }

    public ScanRequestBuilder addCheck(String check) {
        if (StringUtils.isEmpty((CharSequence)check)) {
            log.info("Check is empty and will not be added.");
            return this;
        }
        if (this.checks == null) {
            this.checks = new ArrayList<String>();
        }
        this.checks.add(check);
        return this;
    }

    public ScanRequest build() {
        if (this.url == null) {
            log.info("No URL specified.");
            throw new IllegalArgumentException("URL must not be null.");
        }
        ScanRequest scanRequest = new ScanRequest(this.url);
        if (this.scope != null) {
            log.debug("Set scope.");
            scanRequest.setScope(this.scope);
        }
        if (this.requestHttp != null) {
            log.debug("Set http options.");
            scanRequest.setHttp(this.requestHttp);
        }
        if (this.checks != null) {
            log.debug("Set checks.");
            scanRequest.setChecks(this.checks);
        }
        return scanRequest;
    }
}

