/*
 * Decompiled with CFR 0.152.
 */
package de.irissmann.arachni.client.rest;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.irissmann.arachni.client.ArachniClient;
import de.irissmann.arachni.client.ArachniClientException;
import de.irissmann.arachni.client.Scan;
import de.irissmann.arachni.client.request.ScanRequest;
import de.irissmann.arachni.client.response.ScanResponse;
import de.irissmann.arachni.client.rest.ArachniUtils;
import de.irissmann.arachni.client.rest.ScanRestImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArachniRestClient
implements ArachniClient {
    private static final Logger log = LoggerFactory.getLogger(ArachniRestClient.class);
    private static final String COULD_NOT_CONNECT_MSG = "Could not connect to server.";
    public static final String PATH_SCANS = "scans";
    private final CloseableHttpClient httpClient;
    private final URL baseUrl;
    private Gson gson;
    private final ArachniUtils.MergeConflictStrategy mergeConflictStrategy;

    ArachniRestClient(URL baseUrl, UsernamePasswordCredentials credentials, ArachniUtils.MergeConflictStrategy mergeConflictStrategy) {
        this.baseUrl = baseUrl;
        this.mergeConflictStrategy = mergeConflictStrategy;
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        if (credentials == null) {
            this.httpClient = HttpClientBuilder.create().build();
        } else {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        }
    }

    @Override
    public Scan performScan(ScanRequest scanRequest) {
        return this.performScan(scanRequest, null);
    }

    @Override
    public Scan performScan(ScanRequest scanRequest, String mergeString) {
        String body;
        if (StringUtils.isNotBlank((CharSequence)mergeString)) {
            JsonParser parser = new JsonParser();
            JsonObject scan = this.gson.toJsonTree((Object)scanRequest).getAsJsonObject();
            JsonObject mergeObject = this.gson.toJsonTree((Object)parser.parse(mergeString)).getAsJsonObject();
            ArachniUtils.merge(scan, mergeObject, this.mergeConflictStrategy);
            body = scan.toString();
        } else {
            body = this.gson.toJson((Object)scanRequest);
        }
        String json = this.post(PATH_SCANS, body);
        Map response = (Map)this.gson.fromJson(json, Map.class);
        return new ScanRestImpl((String)response.get("id"), this);
    }

    @Override
    public List<String> getScans() {
        String json = this.get(PATH_SCANS);
        Map scans = (Map)this.gson.fromJson(json, Map.class);
        return new ArrayList<String>(scans.keySet());
    }

    ScanResponse monitor(String id) {
        String json = this.get(String.join((CharSequence)"/", PATH_SCANS, id));
        return (ScanResponse)this.gson.fromJson(json, ScanResponse.class);
    }

    boolean shutdownScan(String id) {
        return this.delete(String.join((CharSequence)"/", PATH_SCANS, id));
    }

    String getScanReportJson(String id) {
        return this.get(String.join((CharSequence)"/", PATH_SCANS, id, "report.json"));
    }

    String getScanReportXml(String id) {
        return this.get(String.join((CharSequence)"/", PATH_SCANS, id, "report.xml"));
    }

    String getScanReportYaml(String id) {
        return this.get(String.join((CharSequence)"/", PATH_SCANS, id, "report.yaml"));
    }

    void getScanReportHtml(String id, OutputStream outstream) {
        this.getBinaryContent(String.join((CharSequence)"/", PATH_SCANS, id, "report.html.zip"), outstream);
    }

    private String get(String path) {
        HttpGet getRequest = new HttpGet(this.getUri(path));
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)getRequest);
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (IOException exception) {
            throw new ArachniClientException(COULD_NOT_CONNECT_MSG, exception);
        }
        finally {
            getRequest.reset();
        }
    }

    private void getBinaryContent(String path, OutputStream outstream) {
        HttpGet getRequest = new HttpGet(this.getUri(path));
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)getRequest);
            response.getEntity().writeTo(outstream);
        }
        catch (IOException exception) {
            throw new ArachniClientException(COULD_NOT_CONNECT_MSG, exception);
        }
        finally {
            getRequest.reset();
        }
    }

    private String post(String path, String body) {
        log.debug("POST request to path {} with json: {}", (Object)path, (Object)body);
        HttpPost postRequest = new HttpPost(this.getUri(path));
        try {
            StringEntity entity = new StringEntity(body);
            postRequest.setEntity((HttpEntity)entity);
            postRequest.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            postRequest.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                String message = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new ArachniClientException(message);
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (IOException exception) {
            throw new ArachniClientException(COULD_NOT_CONNECT_MSG, exception);
        }
        finally {
            postRequest.reset();
        }
    }

    private boolean delete(String path) {
        HttpDelete deleteRequest = new HttpDelete(this.getUri(path));
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)deleteRequest);
            if (response.getStatusLine().getStatusCode() == 200) {
                boolean bl = true;
                return bl;
            }
            try {
                String message = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new ArachniClientException(message);
            }
            catch (IOException exception) {
                throw new ArachniClientException(COULD_NOT_CONNECT_MSG, exception);
            }
        }
        finally {
            deleteRequest.reset();
        }
    }

    private URI getUri(String path) {
        try {
            return new URL(this.baseUrl, path).toURI();
        }
        catch (Exception exception) {
            throw new ArachniClientException("URL not valid.", exception);
        }
    }

    @Override
    public void close() {
        log.info("Try to close http connection.");
        try {
            this.httpClient.close();
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new ArachniClientException(exception.getMessage());
        }
    }
}

