/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseProxyTest;
import de.jakop.lotus.domingo.DBaseDocument;
import de.jakop.lotus.domingo.DBaseItem;
import de.jakop.lotus.domingo.DDatabase;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DEmbeddedObject;
import de.jakop.lotus.domingo.DItem;
import de.jakop.lotus.domingo.DNotesRuntimeException;
import de.jakop.lotus.domingo.DProfileDocument;
import de.jakop.lotus.domingo.DRichTextItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class BaseDocumentProxyTest
extends BaseProxyTest {
    private String itemName = null;

    protected BaseDocumentProxyTest(String name) {
        super(name);
    }

    public final void testGetAttachment() {
        System.out.println("-> testGetAttachment");
        DBaseDocument doc = this.createDBaseDocument();
        DRichTextItem rtItem = doc.createRichTextItem(this.itemName);
        String pre = "testGetAttachment_" + System.currentTimeMillis();
        String suf = ".txt";
        File file = null;
        try {
            file = File.createTempFile(pre, suf);
        }
        catch (IOException e) {
            BaseDocumentProxyTest.assertTrue((String)"Could not create test attachment file.", (boolean)false);
        }
        String key = file.getAbsolutePath();
        rtItem.embedAttachment(key);
        doc.save();
        DEmbeddedObject embObj = doc.getAttachment(file.getName());
        BaseDocumentProxyTest.assertNotNull((String)"The embedded object should not be null.", (Object)embObj);
        BaseDocumentProxyTest.assertEquals((String)"The name of the embedded object should be the same as the name at embedding.", (String)file.getName(), (String)embObj.getName());
        file.delete();
        doc.remove(true);
    }

    public final void testGetEmbeddedObjects() {
        System.out.println("-> testGetEmbeddedObjects");
        DBaseDocument doc = this.createDBaseDocument();
        String pre1 = "testGetEmbeddedObjects1_" + System.currentTimeMillis();
        String pre2 = "testGetEmbeddedObjects2_" + System.currentTimeMillis();
        String suf = ".txt";
        File file1 = null;
        File file2 = null;
        try {
            file1 = File.createTempFile(pre1, suf);
            file2 = File.createTempFile(pre2, suf);
        }
        catch (IOException e) {
            BaseDocumentProxyTest.assertTrue((String)"Could not create test attachment file.", (boolean)false);
        }
        file1.delete();
        file2.delete();
        doc.remove(true);
    }

    public final void testCreateRichTextItem() {
        System.out.println("-> testCreateRichTextItem");
        DBaseDocument doc = this.createDBaseDocument();
        DRichTextItem rtItem = doc.createRichTextItem(this.itemName);
        BaseDocumentProxyTest.assertNotNull((String)"The created RichTextItem should exist.", (Object)rtItem);
        BaseDocumentProxyTest.assertEquals((String)"The RichTextItem's name should match.", (String)rtItem.getName(), (String)rtItem.getName());
    }

    public final void testGetAuthors() {
        System.out.println("-> testGetAuthors");
        DBaseDocument doc = this.createDBaseDocument();
        List authors = doc.getAuthors();
        BaseDocumentProxyTest.assertNotNull((String)"Document should have a authors list.", (Object)authors);
        if (!(doc instanceof DProfileDocument)) {
            BaseDocumentProxyTest.assertTrue((String)"The authors list should be empty.", (authors.size() == 0 ? 1 : 0) != 0);
        }
        doc.save();
        DDatabase database = doc.getParentDatabase();
        if (doc instanceof DDocument) {
            String docId = ((DDocument)doc).getUniversalID();
            doc.recycle();
            doc = database.getDocumentByUNID(docId);
        } else {
            String profileName = ((DProfileDocument)doc).getNameOfProfile();
            String profileKey = ((DProfileDocument)doc).getKey();
            doc.recycle();
            doc = database.getProfileDocument(profileName, profileKey);
        }
        if (doc instanceof DProfileDocument) {
            return;
        }
        String updatedBy = doc.getItemValueString("$UpdatedBy");
        BaseDocumentProxyTest.assertEquals((String)"The $UpdatedBy item should be the user name of the session.", (String)this.getSession().getUserName(), (String)updatedBy);
        authors = doc.getAuthors();
        BaseDocumentProxyTest.assertTrue((String)"The authors list should have at least one entry.", (authors.size() > 0 ? 1 : 0) != 0);
        BaseDocumentProxyTest.assertEquals((String)"The authors name should be the user name of the session.", (Object)this.getSession().getUserName(), authors.get(0));
    }

    public final void testGetLastAccessed() {
        System.out.println("-> testGetLastAccessed");
        DBaseDocument doc = this.createDBaseDocument();
        BaseDocumentProxyTest.assertNotNull((String)"Document now should have a LastAccessed field (also before save).", (Object)doc.getLastAccessed());
        doc.save();
        BaseDocumentProxyTest.assertNotNull((String)"Document now should have a LastAccessed field.", (Object)doc.getLastAccessed());
    }

    public final void testGetLastModified() {
        System.out.println("-> testGetLastModified");
        DBaseDocument doc = this.createDBaseDocument();
        doc.save();
        BaseDocumentProxyTest.assertNotNull((String)"Document now should have a LastModified field.", (Object)doc.getLastModified());
    }

    public final void testGetCreated() {
        System.out.println("-> testGetCreated");
        DBaseDocument doc = this.createDBaseDocument();
        BaseDocumentProxyTest.assertNotNull((String)"Document now should have a created field (also before save).", (Object)doc.getCreated());
        doc.save();
        BaseDocumentProxyTest.assertNotNull((String)"Document now should have a created field.", (Object)doc.getCreated());
    }

    public final void testAppendItemValue() {
        System.out.println("-> testAppendItemValue");
        String appendItemName = "" + System.currentTimeMillis();
        DBaseDocument doc = this.createDBaseDocument();
        DItem nullItem = (DItem)doc.getFirstItem(appendItemName);
        BaseDocumentProxyTest.assertTrue((String)("Document had an item named '" + appendItemName + "' but should NOT have one."), (nullItem == null ? 1 : 0) != 0);
        doc.appendItemValue(appendItemName);
        DItem emptyItem = (DItem)doc.getFirstItem(appendItemName);
        if (emptyItem.getValues().size() == 0) {
            BaseDocumentProxyTest.assertTrue((String)"Item should be empty (item with an empty string), but item IS empty.", (boolean)false);
        } else {
            boolean emptyOK = "".equals((String)emptyItem.getValues().iterator().next());
            BaseDocumentProxyTest.assertTrue((String)("Document should have empty item, but recipient was:" + emptyItem.getValues()), (boolean)emptyOK);
        }
        this.removeItem(doc, appendItemName);
        doc.appendItemValue(appendItemName, 4.4);
        DItem doubleItem = (DItem)doc.getFirstItem(appendItemName);
        Object o = doubleItem.getValues().iterator().next();
        boolean doubleOK = o instanceof Double ? (Double)o == 4.4 : false;
        BaseDocumentProxyTest.assertTrue((String)("Received object should be a Double with a value of 4.4, but is not: " + o), (boolean)doubleOK);
        this.removeItem(doc, appendItemName);
        String value1 = "value1";
        String value2 = "value2";
        doc.appendItemValue(appendItemName, value1);
        doc.appendItemValue(appendItemName, value2);
        DItem item = (DItem)doc.getFirstItem(appendItemName);
        List values = item.getValues();
        BaseDocumentProxyTest.assertTrue((String)("Item should have only one value but has: " + values), (values.size() == 1 && (value1.equals(values.get(0)) || value2.equals(values.get(0))) ? 1 : 0) != 0);
        doc.removeItem(appendItemName);
        this.removeItem(doc, appendItemName);
        doc.appendItemValue(appendItemName, 3);
        DItem intItem = (DItem)doc.getFirstItem(appendItemName);
        o = intItem.getValues().iterator().next();
        boolean intOK = o instanceof Double ? ((Double)o).intValue() == 3 : false;
        BaseDocumentProxyTest.assertTrue((String)("Received object should be Integer 3, but is: " + o.getClass() + ": " + o), (boolean)intOK);
        this.removeItem(doc, appendItemName);
        Integer two = new Integer(2);
        Integer five = new Integer(5);
        ArrayList<Integer> manyInts = new ArrayList<Integer>();
        manyInts.add(two);
        manyInts.add(five);
        doc.appendItemValue(appendItemName, manyInts);
        DItem intListItem = (DItem)doc.getFirstItem(appendItemName);
        List list = intListItem.getValues();
        boolean intListOK = list.size() == 2 ? ((Double)list.get(0)).intValue() == 2 && ((Double)list.get(1)).intValue() == 5 : false;
        BaseDocumentProxyTest.assertTrue((String)("object should be Integer list (" + two + ", " + five + "), but is: " + list), (boolean)intListOK);
        this.removeItem(doc, appendItemName);
        String someText = "some text";
        doc.appendItemValue(appendItemName, someText);
        DItem stringItem = (DItem)doc.getFirstItem(appendItemName);
        Object o2 = stringItem.getValues().iterator().next();
        boolean stringOK = someText.equals(o2);
        BaseDocumentProxyTest.assertTrue((String)("Received object should be String with value '" + someText + "', but is not: " + o2), (boolean)stringOK);
        this.removeItem(doc, appendItemName);
        doc.remove(true);
    }

    public final void testHasItem() {
        System.out.println("-> testHasItem");
        DBaseDocument doc = this.createDBaseDocument();
        BaseDocumentProxyTest.assertTrue((String)("Doc should NOT have a item named " + this.itemName), (!doc.hasItem(this.itemName) ? 1 : 0) != 0);
        doc.appendItemValue(this.itemName);
        BaseDocumentProxyTest.assertTrue((String)("Doc should have a item named " + this.itemName), (boolean)doc.hasItem(this.itemName));
        doc.remove(true);
    }

    public final void testGetItems() {
        System.out.println("-> testGetItems");
        DBaseDocument doc = this.createDBaseDocument();
        HashSet<DBaseItem> itemCache = new HashSet<DBaseItem>();
        Iterator it = doc.getItems();
        while (it.hasNext()) {
            DBaseItem dItem = (DBaseItem)it.next();
            itemCache.add(dItem);
        }
        while (doc.hasItem(this.itemName)) {
            doc.removeItem(this.itemName);
        }
        String someValue = "some value that's value is really unimportant";
        doc.appendItemValue(this.itemName, someValue);
        Iterator it2 = doc.getItems();
        while (it2.hasNext()) {
            DItem dItem = (DItem)it2.next();
            if (itemCache.contains(dItem)) continue;
            List values = dItem.getValues();
            if (values != null) {
                BaseDocumentProxyTest.assertEquals((String)("The only value that was added should be someValue. (" + ((Object)((Object)this)).getClass().getName() + ")"), (Object)someValue, values.get(values.size() - 1));
                continue;
            }
            BaseDocumentProxyTest.assertTrue((String)"Item should have one value, but item list is NULL.", (boolean)false);
        }
    }

    public final void testGetFirstItem() {
        System.out.println("-> testGetFirstItem");
        DBaseDocument doc = this.createDBaseDocument();
        HashSet<DBaseItem> itemCache = new HashSet<DBaseItem>();
        Iterator it = doc.getItems();
        while (it.hasNext()) {
            DBaseItem dItem = (DBaseItem)it.next();
            itemCache.add(dItem);
        }
        while (doc.hasItem(this.itemName)) {
            doc.removeItem(this.itemName);
        }
        String someValue = "some value that's value is really unimportant";
        DItem someItem = doc.appendItemValue(this.itemName, someValue);
        DItem item = (DItem)doc.getFirstItem(this.itemName);
        BaseDocumentProxyTest.assertEquals((String)"Both objects should be equal.", (String)someItem.getValueString(), (String)item.getValueString());
    }

    public final void testRemove1() {
        System.out.println("-> BaseDocumentProxy.testRemove1");
        DBaseDocument doc = this.createDBaseDocument();
        BaseDocumentProxyTest.assertTrue((String)"Document should be removable, because it does already exist in DB.", (boolean)doc.remove(true));
        try {
            BaseDocumentProxyTest.assertTrue((String)"Document should NOT be saved, because it does no longer exist in DB.", (!doc.save() ? 1 : 0) != 0);
        }
        catch (DNotesRuntimeException dNotesRuntimeException) {
            // empty catch block
        }
    }

    public final void testRemove2() {
        System.out.println("-> BaseDocumentProxy.testRemove2");
        DBaseDocument doc = this.createDBaseDocument();
        doc.replaceItemValue("Test", "Test");
        BaseDocumentProxyTest.assertTrue((String)("Document should have been saved. (" + ((Object)((Object)this)).getClass().getName() + ")"), (boolean)doc.save());
        BaseDocumentProxyTest.assertTrue((String)"Document should be removable and be removed.", (boolean)doc.remove(true));
        try {
            BaseDocumentProxyTest.assertTrue((String)"Document should NOT have been saved, because it was previously removed.", (!doc.save() ? 1 : 0) != 0);
        }
        catch (DNotesRuntimeException dNotesRuntimeException) {
            // empty catch block
        }
        BaseDocumentProxyTest.assertTrue((String)"Document should again not be removable, because it does no longer exist.", (!doc.remove(true) ? 1 : 0) != 0);
    }

    public final void testGetItemValueString() {
        System.out.println("-> testGetItemValueString");
        DBaseDocument doc = this.createDBaseDocument();
        String value = doc.getItemValueString(this.itemName);
        BaseDocumentProxyTest.assertEquals((String)("Value of non existent item should be empty string, but was '" + value + "'"), (String)"", (String)value);
        doc.remove(true);
        doc = this.createDBaseDocument();
        doc.appendItemValue(this.itemName);
        value = doc.getItemValueString(this.itemName);
        BaseDocumentProxyTest.assertEquals((String)("Received Text should be '', but was '" + value + "'"), (String)"", (String)value);
        doc.remove(true);
        doc = this.createDBaseDocument();
        String itemValue = "some_item_value";
        doc.appendItemValue(this.itemName, itemValue);
        String value2 = doc.getItemValueString(this.itemName);
        BaseDocumentProxyTest.assertEquals((String)("Received Text should be '" + itemValue + "', but was '" + value2 + "'"), (String)itemValue, (String)value2);
        doc.remove(true);
        doc = this.createDBaseDocument();
        int intValue = 2;
        doc.appendItemValue(this.itemName, intValue);
        value2 = doc.getItemValueString(this.itemName);
        BaseDocumentProxyTest.assertTrue((String)("Received Text should be '', but was '" + value2 + "'"), (boolean)"".equals(value2));
        doc.remove(true);
        doc = this.createDBaseDocument();
        double doubleValue = 2.6;
        doc.appendItemValue(this.itemName, doubleValue);
        String value3 = doc.getItemValueString(this.itemName);
        BaseDocumentProxyTest.assertTrue((String)("Received Text should be '', but was '" + value3 + "'"), (boolean)"".equals(value3));
        doc.remove(true);
    }

    public final void testGetItemValueInteger() {
        System.out.println("-> testGetItemValueInteger");
        DBaseDocument doc = this.createDBaseDocument();
        Integer emptyValue = doc.getItemValueInteger(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Value should be null, but returns: " + emptyValue), (Object)emptyValue);
        doc.remove(true);
        doc = this.createDBaseDocument();
        doc.appendItemValue(this.itemName);
        Integer value = doc.getItemValueInteger(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Received Text should be 0, but was '" + value + "'"), (Object)value);
        doc.remove(true);
        doc = this.createDBaseDocument();
        String stringValue = "someValue";
        doc.appendItemValue(this.itemName, stringValue);
        Integer intResult = doc.getItemValueInteger(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Value should be null, but is " + intResult), (Object)intResult);
        doc.remove(true);
        doc = this.createDBaseDocument();
        int itemValue = 2;
        doc.appendItemValue(this.itemName, itemValue);
        Integer value2 = doc.getItemValueInteger(this.itemName);
        BaseDocumentProxyTest.assertEquals((String)("value should be " + itemValue + ", but was " + value2), (int)itemValue, (int)value2);
        doc.remove(true);
        doc = this.createDBaseDocument();
        double doubleValue = 3.4;
        doc.appendItemValue(this.itemName, doubleValue);
        int intResult2 = doc.getItemValueInteger(this.itemName);
        BaseDocumentProxyTest.assertEquals((String)"wrong value", (int)3, (int)intResult2);
        doc.remove(true);
        doc = this.createDBaseDocument();
        doubleValue = 3.6;
        doc.appendItemValue(this.itemName, doubleValue);
        intResult2 = doc.getItemValueInteger(this.itemName);
        BaseDocumentProxyTest.assertEquals((String)"wrong value", (int)4, (int)intResult2);
        doc.remove(true);
    }

    public final void testGetItemValueDouble() {
        System.out.println("-> testGetItemValueDouble");
        DBaseDocument doc = this.createDBaseDocument();
        Double emptyValue = doc.getItemValueDouble(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Value from a non existing field should return 0.0, but returns: " + emptyValue), (Object)emptyValue);
        doc.remove(true);
        doc = this.createDBaseDocument();
        doc.appendItemValue(this.itemName);
        Double value = doc.getItemValueDouble(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Received Double should be 0.0, but was '" + value + "'"), (Object)value);
        doc.remove(true);
        doc = this.createDBaseDocument();
        String someValue = "someValue";
        doc.appendItemValue(this.itemName, someValue);
        Double doubleResult = doc.getItemValueDouble(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Value of type Double should be null, but is " + doubleResult), (Object)doubleResult);
        doc.remove(true);
        int itemValue = 2;
        DBaseDocument doc2 = this.createDBaseDocument();
        doc2.appendItemValue(this.itemName, itemValue);
        Double doubleValue = doc2.getItemValueDouble(this.itemName);
        BaseDocumentProxyTest.assertEquals((String)("int (from double) should be '" + itemValue + "', but was '" + doubleValue + "'"), (double)itemValue, (double)doubleValue, (double)0.001);
        doc2.remove(true);
        double itemValue2 = 2.6;
        DBaseDocument doc3 = this.createDBaseDocument();
        doc3.appendItemValue(this.itemName, itemValue2);
        Double doubleValue2 = doc3.getItemValueDouble(this.itemName);
        BaseDocumentProxyTest.assertEquals((String)("Received Double should be '" + itemValue2 + "', but was '" + doubleValue2 + "'"), (double)itemValue2, (double)doubleValue2, (double)0.001);
        doc3.remove(true);
    }

    public final void testGetItemValueDate() {
        System.out.println("-> testGetItemValueDate");
        DBaseDocument doc = this.createDBaseDocument();
        Calendar emptyValue = doc.getItemValueDate(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Value should be null, but is " + emptyValue), (Object)emptyValue);
        doc.remove(true);
        doc = this.createDBaseDocument();
        doc.appendItemValue(this.itemName);
        Calendar value = doc.getItemValueDate(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Received Date should be NULL, but was '" + value + "'"), (Object)value);
        doc.remove(true);
        doc = this.createDBaseDocument();
        String someValue = "someValue";
        doc.appendItemValue(this.itemName, someValue);
        Calendar dateResult = doc.getItemValueDate(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Value of type Date should be null , but is " + dateResult), (Object)dateResult);
        doc.remove(true);
        int itemValue = 2;
        DBaseDocument doc2 = this.createDBaseDocument();
        doc2.appendItemValue(this.itemName, itemValue);
        Calendar dateValue = doc2.getItemValueDate(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Received Date should be '" + itemValue + "', but was '" + dateValue + "'"), (Object)dateValue);
        doc2.remove(true);
        double itemValue2 = 2.6;
        DBaseDocument doc3 = this.createDBaseDocument();
        doc3.appendItemValue(this.itemName, itemValue2);
        Calendar dateValue2 = doc3.getItemValueDate(this.itemName);
        BaseDocumentProxyTest.assertNull((String)("Received Date should be '" + itemValue2 + "', but was '" + dateValue2 + "'"), (Object)dateValue2);
        doc3.remove(true);
    }

    public final void testGetItemValue() {
        System.out.println("-> testGetItemValue");
        DBaseDocument doc = this.createDBaseDocument();
        List result = doc.getItemValue(this.itemName);
        BaseDocumentProxyTest.assertTrue((String)("Document should have a list with one entry: '', but has: " + result), (result.size() == 0 ? 1 : 0) != 0);
        doc.remove(true);
        doc = this.createDBaseDocument();
        doc.appendItemValue(this.itemName);
        result = doc.getItemValue(this.itemName);
        BaseDocumentProxyTest.assertTrue((String)("Document should have a list with one entry: '', but has: " + result + " with length " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        doc.remove(true);
        doc = this.createDBaseDocument();
        ArrayList<String> list = new ArrayList<String>();
        String itemValue1 = "itemValue1";
        String itemValue2 = "itemValue2";
        list.add(itemValue1);
        list.add(itemValue2);
        doc.appendItemValue(this.itemName, list);
        List value = doc.getItemValue(this.itemName);
        BaseDocumentProxyTest.assertTrue((String)("Received list should be '" + list + "', but was '" + value + "'"), (boolean)list.equals(value));
        doc.remove(true);
    }

    public final void testReplaceItemValueDateZone() {
    }

    public final void testReplaceItemValueString1() {
        DBaseDocument doc = this.createDBaseDocument();
        doc.appendItemValue(this.itemName);
        String value = doc.getItemValueString(this.itemName);
        BaseDocumentProxyTest.assertTrue((String)"Item should have an empty String as value.", (boolean)"".equals(value));
    }

    public final void testReplaceItemValueString2() {
        DBaseDocument doc = this.createDBaseDocument();
        String expected = "someValue";
        doc.replaceItemValue(this.itemName, expected);
        String result = doc.getItemValueString(this.itemName);
        BaseDocumentProxyTest.assertTrue((String)"Item value is wrong", (boolean)expected.equals(result));
    }

    public final void testReplaceItemValueDouble() {
        DBaseDocument doc = this.createDBaseDocument();
        double expected = 1.2;
        doc.replaceItemValue(this.itemName, expected);
        double result = doc.getItemValueDouble(this.itemName);
        BaseDocumentProxyTest.assertEquals((String)"Item value is wrong", (double)expected, (double)result, (double)0.001);
    }

    public final void testReplaceItemValueInteger() {
        DBaseDocument doc = this.createDBaseDocument();
        int expected = 3;
        doc.replaceItemValue(this.itemName, expected);
        double result = doc.getItemValueInteger(this.itemName).intValue();
        BaseDocumentProxyTest.assertTrue((String)"Item value is wrong", ((double)expected == result ? 1 : 0) != 0);
    }

    public final void testReplaceItemValue() {
        DBaseDocument doc = this.createDBaseDocument();
        ArrayList<String> list = new ArrayList<String>();
        String expected1 = "expected1";
        String expected2 = "expected2";
        list.add(expected1);
        list.add(expected2);
        doc.replaceItemValue(this.itemName, list);
        List result = doc.getItemValue(this.itemName);
        BaseDocumentProxyTest.assertTrue((String)"result is wrong", (boolean)list.equals(result));
    }

    protected final void removeItem(DBaseDocument doc, String pItemName) {
        doc.removeItem(pItemName);
        DBaseItem nullItem = doc.getFirstItem(pItemName);
        BaseDocumentProxyTest.assertTrue((String)("Document had an item named '" + pItemName + "' but that should have been removed."), (nullItem == null ? 1 : 0) != 0);
    }

    protected abstract DBaseDocument createDBaseDocument();

    protected final void setUpTest() {
        this.itemName = "test";
        this.setUpConcreteTest();
    }

    protected abstract void setUpConcreteTest();

    public final String getItemName() {
        return this.itemName;
    }
}

