/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.DDatabase;
import de.jakop.lotus.domingo.DNotesException;
import de.jakop.lotus.domingo.DNotesFactory;
import de.jakop.lotus.domingo.DNotesMonitor;
import de.jakop.lotus.domingo.DSession;
import de.jakop.lotus.domingo.exception.ExceptionUtil;
import de.jakop.lotus.domingo.monitor.ConsoleMonitor;
import java.util.ResourceBundle;
import junit.framework.TestCase;

public abstract class BaseProxyTest
extends TestCase {
    static final String MISCELLANEOUS_EVENTS = "Verschiedene Ereignisse";
    static final String OBJECT_STORE_USAGE = "Objektspeicherbenutzung";
    static final String DATABASE_SIZES = "Datenbank\\Gr\u00f6\u00dfe";
    public static final String LOG_DATABASE = "log.nsf";
    private static ResourceBundle myResources = ResourceBundle.getBundle("de.jakop.lotus.domingo.test");
    private static final String DOMINGO_IMPL = myResources.getString("test.impl");
    private static final String SERVER_NAME = myResources.getString("test.server");
    private static final String HOST_NAME = myResources.getString("test.host");
    private static final String USERNAME = myResources.getString("test.username");
    private static final String PASSWORD = myResources.getString("test.password");
    private DNotesFactory factory;
    private DSession session;
    private DDatabase logDatabase;
    private String serverName = SERVER_NAME;

    public BaseProxyTest(String name) {
        super(name);
    }

    protected final void setUp() throws DNotesException {
        ConsoleMonitor monitor = new ConsoleMonitor();
        this.factory = DNotesFactory.getInstance((String)DOMINGO_IMPL, (DNotesMonitor)monitor);
        if (this.isAssignableFrom(this.factory, "de.jakop.lotus.domingo.http.NotesHttpFactory")) {
            this.session = this.factory.getSession(SERVER_NAME, USERNAME, PASSWORD);
            this.logDatabase = this.session.getDatabase("", LOG_DATABASE);
        } else if (HOST_NAME != null && HOST_NAME.length() > 0) {
            this.session = this.factory.getSession(HOST_NAME, USERNAME, PASSWORD);
            this.logDatabase = this.session.getDatabase("", LOG_DATABASE);
        } else {
            this.session = this.factory.getSession();
            this.logDatabase = this.session.getDatabase(this.serverName, LOG_DATABASE);
        }
        this.setUpTest();
    }

    protected abstract void setUpTest();

    private boolean isAssignableFrom(Object object, String className) {
        if (object == null) {
            return false;
        }
        try {
            return object.getClass().isAssignableFrom(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected final DSession getSession() {
        return this.session;
    }

    protected final DDatabase getDatabase() {
        return this.logDatabase;
    }

    protected final String getServerName() {
        return this.serverName;
    }

    protected final boolean isDIIOP() {
        return HOST_NAME != null && HOST_NAME.length() > 0;
    }

    protected final String getHostName() {
        return HOST_NAME;
    }

    protected final void fail(String message, Throwable t) {
        BaseProxyTest.fail((String)(message + ": " + ExceptionUtil.getStackTrace((Throwable)t)));
    }
}

