/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseProxyTest;
import de.jakop.lotus.domingo.DAgent;
import de.jakop.lotus.domingo.DDatabase;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DNotesException;
import de.jakop.lotus.domingo.DNotesRuntimeException;
import de.jakop.lotus.domingo.DProfileDocument;
import de.jakop.lotus.domingo.DView;
import java.util.Iterator;
import java.util.List;

public final class DatabaseProxyTest
extends BaseProxyTest {
    public DatabaseProxyTest(String name) {
        super(name);
    }

    public void setUpTest() {
    }

    public void testReplicate() {
    }

    public void testCreateReplica() {
        System.out.println("-> testCreateReplica");
        String replicaName = "testLog_" + System.currentTimeMillis() + ".nsf";
        DDatabase replica = null;
        try {
            replica = this.getDatabase().createReplica(this.getServerName(), replicaName);
        }
        catch (DNotesException e1) {
            e1.printStackTrace();
            DatabaseProxyTest.fail((String)("Cannot create replica: " + replicaName));
        }
        replica.remove();
    }

    public void testGetAllDocuments() {
        System.out.println("-> testGetAllDocuments");
        String dbName = "testGetAllDocuments_" + System.currentTimeMillis() + ".nsf";
        DDatabase newDB = this.getSession().createDatabase(this.getServerName(), dbName);
        DDocument doc1 = newDB.createDocument();
        doc1.replaceItemValue("item1", "value1");
        doc1.replaceItemValue("item2", "value2");
        doc1.save();
        DDocument doc2 = newDB.createDocument();
        doc2.replaceItemValue("item3", "value3");
        doc2.replaceItemValue("item4", "value4");
        doc2.save();
        int docCounter = 0;
        Iterator it = this.getDatabase().getAllDocuments();
        for (int i = 0; i < 2; ++i) {
            DDocument doc = (DDocument)it.next();
            DatabaseProxyTest.assertNotNull((String)("At least two documents should be in database, but no " + (2 - docCounter) + " is missing."), (Object)doc);
            if (doc == null) continue;
            ++docCounter;
        }
        DatabaseProxyTest.assertTrue((String)"Database should hold at least 2 documents.", (2 == docCounter ? 1 : 0) != 0);
        newDB.remove();
    }

    public void testCreateDatabaseFromTemplate() {
        System.out.println("-> testCreateDatabaseFromTemplate");
        DDatabase template = null;
        try {
            template = this.getSession().getDatabase(this.getServerName(), "log.ntf");
        }
        catch (DNotesException e) {
            e.printStackTrace();
            DatabaseProxyTest.fail((String)"Cannot open local database log.ntf");
        }
        String newName = "testCreateDatabaseFromTemplate_" + System.currentTimeMillis() + ".nsf";
        DDatabase newDB = null;
        try {
            System.out.println("   template.createDatabaseFromTemplate");
            newDB = template.createDatabaseFromTemplate(this.getServerName(), newName, true);
        }
        catch (DNotesException e) {
            DatabaseProxyTest.assertTrue((String)("Database could not be created: " + (Object)((Object)e)), (boolean)false);
        }
        DatabaseProxyTest.assertNotNull((String)"Database not created.", (Object)newDB);
        System.out.println("   db created");
        DatabaseProxyTest.assertTrue((String)"Databases name does not match.", (boolean)newDB.getFilePath().endsWith(newName));
        DView view = newDB.getView("Datenbank\\Gr\u00f6\u00dfe");
        DatabaseProxyTest.assertNotNull((String)"The received view should not be NULL.", (Object)view);
        DatabaseProxyTest.assertEquals((String)"The views name does not match.", (String)"Datenbank\\Gr\u00f6\u00dfe", (String)view.getName());
        DDatabase newDB2 = null;
        try {
            newDB2 = template.createDatabaseFromTemplate(this.getServerName(), newName, true);
        }
        catch (DNotesException e) {
            System.out.println("As expected: " + e.getMessage());
        }
        DatabaseProxyTest.assertNull((String)"Database should NOT have been created: ", (Object)newDB2);
        newDB.remove();
    }

    public void testRemove() {
        System.out.println("-> DatabaseProxy.testRemove");
        String dbName = "testRemove_" + System.currentTimeMillis() + ".nsf";
        DDatabase lDatabase = this.getSession().createDatabase(this.getServerName(), dbName);
        lDatabase.remove();
    }

    public void testCreateDocument() {
        System.out.println("-> testCreateDocument");
        DDocument doc = this.getDatabase().createDocument();
        DatabaseProxyTest.assertTrue((String)"Document should be new.", (boolean)doc.isNewNote());
    }

    public void testGetDocumentByUNID() {
        System.out.println("-> testGetDocumentByUNID");
        DDocument doc = this.getDatabase().createDocument();
        doc.save();
        DDocument newDoc = this.getDatabase().getDocumentByUNID(doc.getUniversalID());
        DatabaseProxyTest.assertEquals((String)"UniversalIds must be equal", (String)doc.getUniversalID(), (String)newDoc.getUniversalID());
        newDoc.remove(true);
    }

    public void testGetDocumentByID() {
        System.out.println("-> testGetDocumentByID");
        DDocument doc = this.getDatabase().createDocument();
        doc.save();
        DDocument newDoc = this.getDatabase().getDocumentByID(doc.getNoteID());
        DatabaseProxyTest.assertEquals((String)"NoteIds must be equal", (String)doc.getNoteID(), (String)newDoc.getNoteID());
        newDoc.remove(true);
    }

    public void testGetFileName() {
        System.out.println("-> testGetFileName");
        String fileName = this.getDatabase().getFileName();
        String path = this.getDatabase().getFilePath();
        DatabaseProxyTest.assertTrue((String)"The fileName should be equals to the end of the file path", (boolean)path.endsWith(fileName));
    }

    public void testGetFilePath() {
        System.out.println("-> testGetFilePath");
        String path = this.getDatabase().getFilePath();
        DatabaseProxyTest.assertTrue((String)"At least the database file should exist.", (path != null && path.length() > 0 ? 1 : 0) != 0);
    }

    public void testGetCurrentAccessLevel() {
        System.out.println("-> testGetCurrentAccessLevel");
        int level = this.getDatabase().getCurrentAccessLevel();
        DatabaseProxyTest.assertTrue((String)"Illegal access level", (0 <= level && level <= 6 ? 1 : 0) != 0);
    }

    public void testGetProfileDocument() {
        System.out.println("-> testGetProfileDocument");
        String profile = "some_profile_name";
        String profileKey = "some_Profile_Key";
        DProfileDocument pDoc = this.getDatabase().getProfileDocument(profile, profileKey);
        DatabaseProxyTest.assertNotNull((String)"Document should note be null.", (Object)pDoc);
    }

    public void testGetView() {
        System.out.println("-> testGetView");
        String viewName = "Datenbank\\Gr\u00f6\u00dfe";
        DView view = this.getDatabase().getView(viewName);
        DatabaseProxyTest.assertTrue((String)("Each Notes log DB (log.nsf) should have a view '" + viewName + ", but this DB has not: " + view), (view != null && viewName.equals(view.getName()) ? 1 : 0) != 0);
    }

    public void testGetAgent() {
        System.out.println("-> testGetAgent");
        String agentName = "Copy to Personal Address Book";
        DDatabase nab = null;
        try {
            nab = this.getSession().getDatabase(this.getServerName(), "names.nsf");
        }
        catch (DNotesException e) {
            e.printStackTrace();
            DatabaseProxyTest.fail((String)"Cannot open local names.nsf");
        }
        DAgent agent = nab.getAgent(agentName);
        DatabaseProxyTest.assertTrue((String)("Each Notes NAB (names.nsf) should have an agent '" + agentName + ", but this DB has not."), (agent != null && agentName.equals(agent.getName()) ? 1 : 0) != 0);
    }

    public void testAllDocs() {
        DDocument doc = null;
        try {
            DDatabase nab = this.getSession().getDatabase("", "names.nsf");
            DView users = nab.getView("($Users)");
            Iterator allDocs = users.getAllDocuments();
            doc = (DDocument)allDocs.next();
        }
        catch (DNotesException e) {
            e.printStackTrace();
            DatabaseProxyTest.fail((String)"Cannot open local names.nsf");
        }
        try {
            List itemValue = doc.getItemValue("$Revisions");
            System.out.println(itemValue);
        }
        catch (DNotesRuntimeException e) {
            e.printStackTrace();
            DatabaseProxyTest.fail((String)"Cannot get date/time.");
        }
    }
}

