/*
 * Decompiled with CFR 0.152.
 */
package de.jakop.lotus.domingo;

import de.jakop.lotus.domingo.BaseProxyTest;
import de.jakop.lotus.domingo.DBaseDocument;
import de.jakop.lotus.domingo.DDateRange;
import de.jakop.lotus.domingo.DDocument;
import de.jakop.lotus.domingo.DItem;
import de.jakop.lotus.domingo.util.GregorianDate;
import de.jakop.lotus.domingo.util.GregorianDateRange;
import de.jakop.lotus.domingo.util.GregorianDateTime;
import de.jakop.lotus.domingo.util.GregorianDateTimeRange;
import de.jakop.lotus.domingo.util.GregorianTime;
import de.jakop.lotus.domingo.util.GregorianTimeRange;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public final class DateTimeTest
extends BaseProxyTest {
    private static final String ITEM_NAME = "test";

    public DateTimeTest(String name) {
        super(name);
    }

    public void testReplaceItemValueDateGregorianDateTimeWinter() {
        this.testReplaceItemValueDateGregorianDateTime(0, TimeZone.getDefault());
    }

    public void testReplaceItemValueDateGregorianDateTimeSummer() {
        this.testReplaceItemValueDateGregorianDateTime(6, TimeZone.getDefault());
    }

    public void testReplaceItemValueDateGregorianDateTimeBerlinWinter() {
        this.testReplaceItemValueDateGregorianDateTime(0, TimeZone.getTimeZone("Europe/Berlin"));
    }

    public void testReplaceItemValueDateGregorianDateTimeBerlinSummer() {
        this.testReplaceItemValueDateGregorianDateTime(6, TimeZone.getTimeZone("Europe/Berlin"));
    }

    public void testReplaceItemValueDateGregorianDateTimeLosAngelesWinter() {
        this.testReplaceItemValueDateGregorianDateTime(0, TimeZone.getTimeZone("America/Los_Angeles"));
    }

    public void testReplaceItemValueDateGregorianDateTimeLosAngelesSummer() {
        this.testReplaceItemValueDateGregorianDateTime(6, TimeZone.getTimeZone("America/Los_Angeles"));
    }

    public void testReplaceItemValueDateGregorianDateTimeMoscowWinter() {
        this.testReplaceItemValueDateGregorianDateTime(0, TimeZone.getTimeZone("Europe/Moscow"));
    }

    public void testReplaceItemValueDateGregorianDateTimeMoscowSummer() {
        this.testReplaceItemValueDateGregorianDateTime(6, TimeZone.getTimeZone("Europe/Moscow"));
    }

    public void testReplaceItemValueDateGregorianDateTimeKatmanduWinter() {
        this.testReplaceItemValueDateGregorianDateTime(0, TimeZone.getTimeZone("Asia/Katmandu"));
    }

    public void testReplaceItemValueDateGregorianDateTimeKatmanduSummer() {
        this.testReplaceItemValueDateGregorianDateTime(6, TimeZone.getTimeZone("Asia/Katmandu"));
    }

    public void testReplaceItemValueDateGregorianDateTimeFijiWinter() {
        this.testReplaceItemValueDateGregorianDateTime(0, TimeZone.getTimeZone("Pacific/Fiji"));
    }

    public void testReplaceItemValueDateGregorianDateTimeFijiSummer() {
        this.testReplaceItemValueDateGregorianDateTime(6, TimeZone.getTimeZone("Pacific/Fiji"));
    }

    public void testReplaceItemValueDateGregorianDateTimeKuwaitWinter() {
        this.testReplaceItemValueDateGregorianDateTime(0, TimeZone.getTimeZone("Asia/Kuwait"));
    }

    public void testReplaceItemValueDateGregorianDateTimeKuwaitSummer() {
        this.testReplaceItemValueDateGregorianDateTime(6, TimeZone.getTimeZone("Asia/Kuwait"));
    }

    public void testReplaceItemValueDateGregorianDateTime(int month, TimeZone zone) {
        System.out.println("-> testReplaceItemValueDateGregorianDateTime: Month: " + month + ", Zone: " + zone.getID());
        DBaseDocument doc = this.createDBaseDocument();
        doc.replaceItemValue("Form", "testReplaceItemValueDateGregorianDateTime");
        GregorianDateTime value = new GregorianDateTime(2004, month, 17, 15, 59, 58, zone);
        doc.replaceItemValue(ITEM_NAME, (Calendar)value);
        doc.save();
        Calendar result = doc.getItemValueDate(ITEM_NAME);
        result.setTimeZone(zone);
        this.assertValidCalendar((Calendar)value, result);
        result = ((DItem)doc.getFirstItem(ITEM_NAME)).getValueDateTime();
        result.setTimeZone(zone);
        this.assertValidCalendar((Calendar)value, result);
    }

    public void testReplaceItemValueDateGregorianDateWinter() {
        this.testReplaceItemValueDateGregorianDate(0);
    }

    public void testReplaceItemValueDateGregorianDateSummer() {
        this.testReplaceItemValueDateGregorianDate(6);
    }

    public void testReplaceItemValueDateGregorianDate(int month) {
        System.out.println("-> testReplaceItemValueDateGregorianDate: Month: " + month);
        DBaseDocument doc = this.createDBaseDocument();
        doc.replaceItemValue("Form", "testReplaceItemValueDateGregorianDate");
        GregorianDate value = new GregorianDate(2005, month, 17);
        doc.replaceItemValue(ITEM_NAME, (Calendar)value);
        doc.save();
        Calendar result = doc.getItemValueDate(ITEM_NAME);
        System.out.println(value.getTime() + " zone: " + value.getTimeZone().getID());
        System.out.println(result.getTime() + " zone: " + result.getTimeZone().getID());
        int valueZoneOffset = value.getTimeZone().getOffset(value.getTimeInMillis()) / 60000;
        int resultZoneOffset = result.getTimeZone().getOffset(value.getTimeInMillis()) / 60000;
        DateTimeTest.assertTrue((String)"wrong type", (boolean)(result instanceof GregorianDate));
        DateTimeTest.assertEquals((String)"wrong zone", (int)valueZoneOffset, (int)resultZoneOffset);
        DateTimeTest.assertEquals((String)"wrong time", (Object)value.getTime(), (Object)result.getTime());
        result = ((DItem)doc.getFirstItem(ITEM_NAME)).getValueDateTime();
        System.out.println(result.getTime() + " zone: " + result.getTimeZone().getID());
        resultZoneOffset = result.getTimeZone().getOffset(value.getTimeInMillis()) / 60000;
        DateTimeTest.assertTrue((String)"wrong type", (boolean)(result instanceof GregorianDate));
        DateTimeTest.assertEquals((String)"wrong zone", (int)valueZoneOffset, (int)resultZoneOffset);
        DateTimeTest.assertEquals((String)"wrong time", (Object)value.getTime(), (Object)result.getTime());
    }

    public void testReplaceItemValueDateGregorianTimeWinter() {
        this.testReplaceItemValueDateGregorianTime(0);
    }

    public void testReplaceItemValueDateGregorianTimeSummer() {
        this.testReplaceItemValueDateGregorianTime(6);
    }

    public void testReplaceItemValueDateGregorianTime(int month) {
        System.out.println("-> testReplaceItemValueDateGregorianTimeWinter: Month: " + month);
        DBaseDocument doc = this.createDBaseDocument();
        doc.replaceItemValue("Form", "testReplaceItemValueDateGregorianTime");
        GregorianTime value = new GregorianTime(15, 59, 58);
        doc.replaceItemValue(ITEM_NAME, (Calendar)value);
        doc.save();
        Calendar result = doc.getItemValueDate(ITEM_NAME);
        System.out.println(value.getTime() + " zone: " + value.getTimeZone().getID());
        System.out.println(result.getTime() + " zone: " + result.getTimeZone().getID());
        DateTimeTest.assertTrue((String)"wrong type", (boolean)(result instanceof GregorianTime));
        DateTimeTest.assertEquals((String)"wrong time", (Object)value.getTime(), (Object)result.getTime());
        result = ((DItem)doc.getFirstItem(ITEM_NAME)).getValueDateTime();
        System.out.println(result.getTime() + " zone: " + result.getTimeZone().getID());
        DateTimeTest.assertTrue((String)"wrong type", (boolean)(result instanceof GregorianTime));
        DateTimeTest.assertEquals((String)"wrong time", (Object)value.getTime(), (Object)result.getTime());
    }

    public void testReplaceItemValueListGregorianDateTimeWinter() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getDefault());
    }

    public void testReplaceItemValueListGregorianDateTimeSummer() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getDefault());
    }

    public void testReplaceItemValueListGregorianDateTimeBerlinWinter() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("Europe/Berlin"));
    }

    public void testReplaceItemValueListGregorianDateTimeBerlinSummer() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("Europe/Berlin"));
    }

    public void testReplaceItemValueListGregorianDateTimeLosAngelesWinter() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("America/Los_Angeles"));
    }

    public void testReplaceItemValueListGregorianDateTimeLosAngelesSummer() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("America/Los_Angeles"));
    }

    public void testReplaceItemValueListGregorianDateTimeMoscowWinter() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("Europe/Moscow"));
    }

    public void testReplaceItemValueListGregorianDateTimeMoscowSummer() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("Europe/Moscow"));
    }

    public void testReplaceItemValueListGregorianDateTimeKatmanduWinter() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("Asia/Katmandu"));
    }

    public void testReplaceItemValueListGregorianDateTimeKatmanduSummer() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("Asia/Katmandu"));
    }

    public void testReplaceItemValueListGregorianDateTimeFijiWinter() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("Pacific/Fiji"));
    }

    public void testReplaceItemValueListGregorianDateTimeFijiSummer() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("Pacific/Fiji"));
    }

    public void testReplaceItemValueListGregorianDateTimeKuwaitWinter() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("Asia/Kuwait"));
    }

    public void testReplaceItemValueListGregorianDateTimeKuwaitSummer() {
        this.testReplaceItemValueListGregorianDateTime(TimeZone.getTimeZone("Asia/Kuwait"));
    }

    public void testReplaceItemValueListGregorianDateTime(TimeZone zone) {
        System.out.println("-> testReplaceItemValueListGregorianDateTime");
        DBaseDocument doc = this.createDBaseDocument();
        doc.replaceItemValue("Form", "testReplaceItemValueListGregorianDateTime");
        ArrayList<GregorianDateTime> list = new ArrayList<GregorianDateTime>();
        GregorianDateTime value1 = new GregorianDateTime(2004, 0, 17, 15, 59, 58, zone);
        GregorianDateTime value2 = new GregorianDateTime(2004, 6, 17, 15, 59, 58, zone);
        list.add(value1);
        list.add(value2);
        doc.replaceItemValue(ITEM_NAME, list);
        doc.save();
        List result = doc.getItemValue(ITEM_NAME);
        this.assertEqualsDateTimeList(list, result, zone);
        result = ((DItem)doc.getFirstItem(ITEM_NAME)).getValues();
        this.assertEqualsDateTimeList(list, result, zone);
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeWinter() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getDefault());
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeSummer() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getDefault());
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeBerlinWinter() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("Europe/Berlin"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeBerlinSummer() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("Europe/Berlin"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeLosAngelesWinter() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("America/Los_Angeles"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeLosAngelesSummer() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("America/Los_Angeles"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeMoscowWinter() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("Europe/Moscow"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeMoscowSummer() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("Europe/Moscow"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeKatmanduWinter() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("Asia/Katmandu"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeKatmanduSummer() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("Asia/Katmandu"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeFijiWinter() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("Pacific/Fiji"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeFijiSummer() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("Pacific/Fiji"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeKuwaitWinter() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("Asia/Kuwait"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTimeKuwaitSummer() {
        this.testReplaceItemValueDateRangeGregorianDateTime(TimeZone.getTimeZone("Asia/Kuwait"));
    }

    public void testReplaceItemValueDateRangeGregorianDateTime(TimeZone zone) {
        GregorianDateTime value1 = new GregorianDateTime(2004, 0, 17, 15, 59, 58, zone);
        GregorianDateTime value2 = new GregorianDateTime(2004, 6, 17, 15, 59, 58, zone);
        GregorianDateTimeRange range = new GregorianDateTimeRange((Calendar)value1, (Calendar)value2);
        this.testReplaceItemValueDateRange((DDateRange)range, zone);
    }

    public void testReplaceItemValueDateRangeGregorianDate() {
        GregorianDate value1 = new GregorianDate(2004, 0, 17);
        GregorianDate value2 = new GregorianDate(2004, 6, 17);
        GregorianDateRange range = new GregorianDateRange((Calendar)value1, (Calendar)value2);
        this.testReplaceItemValueDateRange((DDateRange)range, value1.getTimeZone());
    }

    public void testReplaceItemValueDateRangeGregorianTime() {
        GregorianTime value1 = new GregorianTime(15, 59, 58);
        GregorianTime value2 = new GregorianTime(16, 59, 58);
        GregorianTimeRange range = new GregorianTimeRange((Calendar)value1, (Calendar)value2);
        this.testReplaceItemValueDateRange((DDateRange)range, value1.getTimeZone());
    }

    public void testReplaceItemValueDateRange(Calendar value1, Calendar value2, TimeZone zone) {
        this.testReplaceItemValueDateRange((DDateRange)new GregorianDateRange(value1, value2), zone);
    }

    private void testReplaceItemValueDateRange(DDateRange value, TimeZone zone) {
        System.out.println("-> testReplaceItemValueDateRange: Zone: " + zone.getID());
        DDocument doc = this.getDatabase().createDocument();
        doc.replaceItemValue("Form", "testReplaceItemValueDateRange");
        doc.replaceItemValue(ITEM_NAME, value);
        doc.save();
        DDateRange result = doc.getItemValueDateRange(ITEM_NAME);
        this.assertEqualsDateRange(value, result, zone);
        DItem item = (DItem)doc.getFirstItem(ITEM_NAME);
        result = item.getValueDateRange();
        this.assertEqualsDateRange(value, result, zone);
    }

    private void assertEqualsDateTimeList(List expected, List result, TimeZone zone) {
        DateTimeTest.assertEquals((String)"result length is wrong", (int)expected.size(), (int)result.size());
        Calendar value1 = (Calendar)expected.get(0);
        Calendar value2 = (Calendar)expected.get(1);
        Calendar result1 = (Calendar)result.get(0);
        Calendar result2 = (Calendar)result.get(1);
        result1.setTimeZone(zone);
        result2.setTimeZone(zone);
        this.assertValidCalendar(value1, result1);
        this.assertValidCalendar(value2, result2);
    }

    private void assertValidCalendar(Calendar expected, Calendar result) {
        System.out.println(expected.getTime() + " zone: " + expected.getTimeZone().getID());
        System.out.println(result.getTime() + " zone: " + result.getTimeZone().getID());
        int valueZoneOffset = expected.getTimeZone().getOffset(expected.getTimeInMillis()) / 60000;
        int resultZoneOffset = result.getTimeZone().getOffset(expected.getTimeInMillis()) / 60000;
        DateTimeTest.assertEquals((long)0L, (long)((result.getTimeInMillis() - expected.getTimeInMillis()) / 60000L));
        DateTimeTest.assertEquals((String)"wrong zone", (int)valueZoneOffset, (int)resultZoneOffset);
        DateTimeTest.assertEquals((String)"wrong time", (Object)expected.getTime(), (Object)result.getTime());
    }

    private void assertEqualsDateRange(DDateRange value, DDateRange result, TimeZone zone) {
        Calendar value1 = value.getFrom();
        Calendar value2 = value.getTo();
        Calendar result1 = result.getFrom();
        Calendar result2 = result.getTo();
        result1.setTimeZone(zone);
        result2.setTimeZone(zone);
        this.assertValidCalendar(value1, result1);
        this.assertValidCalendar(value2, result2);
    }

    protected DBaseDocument createDBaseDocument() {
        return this.getDatabase().createDocument();
    }

    protected void setUpTest() {
    }
}

